/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.mif;

import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Projection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Vector;

public class OMSubtraction
extends OMGraphicAdapter
implements Serializable {
    Color fillcolor;
    SubArea outer;
    Area area;
    GeneralPath gpath;
    Vector subs;
    Projection project;

    public OMSubtraction(double[] lat, double[] lon) {
        super(1, 0, 0);
        this.outer = new SubArea(lat, lon);
    }

    boolean contains(double[] latp, double[] lonp) {
        if (this.outer.contains(latp, lonp)) {
            if (this.subs == null) {
                this.subs = new Vector();
            }
            this.subs.addElement(new SubArea(latp, lonp));
            return true;
        }
        return false;
    }

    public boolean generate(Projection proj) {
        if (proj == null) {
            System.err.println("OMText: null projection in generate!");
            return false;
        }
        this.project = proj;
        if (!this.outer.isPlotable(proj)) {
            return false;
        }
        this.area = this.outer.getArea(proj);
        if (this.subs != null) {
            int sublen = this.subs.size();
            for (int i = 0; i < sublen; ++i) {
                SubArea sb = (SubArea)this.subs.elementAt(i);
                this.area.subtract(sb.getArea(proj));
            }
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    public synchronized void render(Graphics g) {
        if (this.getNeedToRegenerate()) {
            return;
        }
        if (!this.outer.isPlotable(this.project)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.getFillPaint());
        g2.fill(this.area);
    }

    public float distance(double x, double y) {
        return 0.0f;
    }

    class SubArea {
        double[] lat;
        double[] lon;
        int[] x;
        int[] y;
        int len;
        GeneralPath gpath;

        SubArea(double[] lat, double[] lon) {
            this.lat = lat;
            this.lon = lon;
            this.len = lat.length;
            this.x = new int[this.len];
            this.y = new int[this.len];
        }

        Area getArea(Projection proj) {
            Point pt = new Point();
            for (int i = 0; i < this.len; ++i) {
                proj.forward(this.lat[i], this.lon[i], (Point2D)pt);
                this.x[i] = pt.x;
                this.y[i] = pt.y;
            }
            return new Area(new Polygon(this.x, this.y, this.len));
        }

        boolean isPlotable(Projection proj) {
            return proj.isPlotable(this.lat[0], this.lon[0]);
        }

        boolean contains(double[] latp, double[] lonp) {
            if (this.gpath == null) {
                this.gpath = new GeneralPath();
                for (int i = 0; i < this.len; ++i) {
                    if (i == 0) {
                        this.gpath.moveTo((float)this.lat[0], (float)this.lon[0]);
                    }
                    this.gpath.lineTo((float)this.lat[i], (float)this.lon[i]);
                }
                this.gpath.closePath();
            }
            int len = latp.length;
            for (int i = 0; i < len; ++i) {
                if (!this.gpath.contains(latp[i], lonp[i])) continue;
                return true;
            }
            return false;
        }
    }
}

