/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkBoundingPoly;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.io.IOException;

public class LinkMapRequest {
    protected LatLonPoint center;
    protected float scale;
    protected LinkBoundingPoly[] boundingPolys;
    protected int height;
    protected int width;
    protected LinkProperties properties;
    protected static float version = 0.6f;
    String linkStatus = "\r";

    public LinkMapRequest(Link link) throws IOException {
        this.linkStatus = this.read(link);
    }

    public String getType() {
        return "<MR>";
    }

    public String getLinkStatus() {
        return this.linkStatus;
    }

    public static void write(float centerLat, float centerLon, float scale, int height, int width, LinkBoundingPoly[] boundingPolys, LinkProperties props, Link link) throws IOException {
        int i;
        link.start("<MR>");
        link.dos.writeFloat(version);
        link.dos.writeFloat(centerLat);
        link.dos.writeFloat(centerLon);
        link.dos.writeFloat(scale);
        link.dos.writeInt(height);
        link.dos.writeInt(width);
        link.dos.writeInt(boundingPolys.length);
        for (i = 0; i < boundingPolys.length; ++i) {
            boundingPolys[i].write(link.dos);
        }
        props.write(link);
        link.end("\r");
        if (Debug.debugging("link")) {
            System.out.println("LinkMapRequest wrote:");
            System.out.println(" version = " + version);
            System.out.println(" lat = " + centerLat);
            System.out.println(" lon = " + centerLon);
            System.out.println(" scale = " + scale);
            System.out.println(" height = " + height);
            System.out.println(" width = " + width);
            System.out.println(" bounding polys:");
            for (i = 0; i < boundingPolys.length; ++i) {
                System.out.println(boundingPolys[i]);
            }
            System.out.println(" Args:");
            System.out.println(props);
        }
    }

    public String read(Link link) throws IOException {
        Debug.message("link", "LinkMapRequest: read()");
        float ver = link.dis.readFloat();
        if (ver != version) {
            if ((double)ver == 0.1) {
                throw new IOException("LinkMapRequest: Versions do not match! DANGER!");
            }
            Debug.message("link", "LinkMapRequest: Versions do not match");
        }
        float lat = link.dis.readFloat();
        float lon = link.dis.readFloat();
        this.center = new LatLonPoint.Float(lat, lon);
        this.scale = link.dis.readFloat();
        this.height = link.dis.readInt();
        this.width = link.dis.readInt();
        int length = link.dis.readInt();
        this.boundingPolys = new LinkBoundingPoly[length];
        for (int i = 0; i < this.boundingPolys.length; ++i) {
            this.boundingPolys[i] = new LinkBoundingPoly(link.dis);
        }
        this.properties = new LinkProperties(link);
        return link.readDelimiter(false);
    }

    public LatLonPoint getCenter() {
        return this.center;
    }

    public float getScale() {
        return this.scale;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public LinkBoundingPoly[] getBoundingPolys() {
        return this.boundingPolys;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("LinkMapRequest:\n");
        s.append("LinkMapRequest wrote:\n");
        s.append(" version = ").append(version).append("\n");
        s.append(" center = ").append(this.center).append("\n");
        s.append(" scale = ").append(this.scale).append("\n");
        s.append(" height = ").append(this.height).append("\n");
        s.append(" width = ").append(this.width).append("\n");
        s.append(" ").append(this.boundingPolys.length).append(" bounding polys:");
        for (int i = 0; i < this.boundingPolys.length; ++i) {
            s.append("\n").append(this.boundingPolys[i]);
        }
        return s.toString();
    }
}

