/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ProjectionSupport;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.ProjectionLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionMenu
extends AbstractOpenMapMenu
implements ActionListener,
ProjectionListener,
PropertyChangeListener {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.menu.ProjectionMenu");
    public static final String defaultText = "Projection";
    protected transient ProjectionSupport projectionSupport = new ProjectionSupport(this, false);
    protected transient Projection projection;
    protected transient Component projComponent;
    public static final transient String projCmd = "setProj";
    protected ProjectionFactory projectionFactory;

    public ProjectionMenu() {
        this.setText(this.i18n.get(this, "projectionMenu", defaultText));
    }

    public void configure(List<ProjectionLoader> loaders) {
        this.removeAll();
        ButtonGroup group = new ButtonGroup();
        for (ProjectionLoader pl : loaders) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(pl.getPrettyName());
            rb.setActionCommand(projCmd);
            String plclassname = pl.getProjectionClass().getName();
            rb.setName(plclassname);
            rb.setToolTipText(pl.getDescription());
            rb.addActionListener(this);
            group.add(rb);
            this.add(rb);
        }
        this.setProjection(this.projection);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        logger.fine("received command: " + command);
        if (command == projCmd) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)ae.getSource();
            String projclassname = rb.getName();
            logger.fine("ProjectionMenu new proj name: " + projclassname);
            try {
                Projection newProj = this.getProjectionFactory().makeProjection(projclassname, this.projection);
                this.fireProjectionChanged(newProj);
            }
            catch (ProjectionException pe) {
                logger.warning(pe.getMessage());
                rb.setEnabled(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName() == "AvailableProjections") {
            this.configure((List)pce.getNewValue());
        }
    }

    @Override
    public void projectionChanged(ProjectionEvent e) {
        Projection newProj = e.getProjection();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(newProj != null ? newProj.toString() : "null");
        }
        if (!(newProj == null || this.projection != null && this.projection.equals(newProj))) {
            this.setProjection(newProj.makeClone());
            Object source = e.getSource();
            if (source instanceof Component) {
                this.projComponent = (Component)source;
            }
        }
    }

    protected synchronized void setProjection(Projection aProjection) {
        this.projection = aProjection;
        if (this.projection == null) {
            return;
        }
        String newProjClassName = this.projection.getClass().getName();
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem item = this.getItem(i);
            if (!newProjClassName.equals(item.getName())) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProjectionMenu | setting " + item.getName() + " as active");
            }
            item.setSelected(true);
            return;
        }
    }

    public void setupListeners(MapBean map) {
        logger.fine("seting up listeners");
        this.addProjectionListener(map);
        map.addProjectionListener(this);
    }

    public void undoListeners(MapBean map) {
        this.removeProjectionListener(map);
        map.removeProjectionListener(this);
    }

    protected synchronized void addProjectionListener(ProjectionListener l) {
        this.projectionSupport.add(l);
    }

    protected synchronized void removeProjectionListener(ProjectionListener l) {
        this.projectionSupport.remove(l);
    }

    public void fireProjectionChanged(Projection p) {
        this.projectionSupport.fireProjectionChanged(p);
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setupListeners((MapBean)someObj);
        }
        if (someObj instanceof ProjectionFactory) {
            this.projectionFactory = (ProjectionFactory)someObj;
            this.projectionFactory.addPropertyChangeListener(this);
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            this.undoListeners((MapBean)someObj);
        }
        if (someObj.equals(this.projectionFactory)) {
            this.projectionFactory.removePropertyChangeListener(this);
            this.projectionFactory = null;
        }
        if (someObj.equals(this)) {
            this.dispose();
        }
    }

    public ProjectionFactory getProjectionFactory() {
        if (this.projectionFactory == null) {
            this.projectionFactory = ProjectionFactory.loadDefaultProjections();
        }
        return this.projectionFactory;
    }

    public void setProjectionFactory(ProjectionFactory projectionFactory) {
        this.projectionFactory = projectionFactory;
    }

    public void dispose() {
        this.projectionSupport.dispose();
    }
}

