/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.event.OMMouseMode;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.EmbeddedNavPanel;
import com.bbn.openmap.gui.EmbeddedScaleDisplayPanel;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.proj.ProjectionStack;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class OverlayMapPanel
extends BasicMapPanel {
    private static final long serialVersionUID = 1L;
    public static final String ACTIVE_WIDGET_COLOR_PROPERTY = "activeWidgets";
    public static final String INACTIVE_WIDGET_COLOR_PROPERTY = "inactiveWidgets";
    public static final String WIDGET_SIZE_PROPERTY = "widgetSize";
    protected int DEFAULT_WIDGET_BUTTON_SIZE;
    protected DrawingAttributes activeWidgetColors;
    protected DrawingAttributes inactiveWidgetColors;
    protected int widgetButtonSize;
    protected JPanel widgets;

    public OverlayMapPanel() {
        super(new PropertyHandler(new Properties()), false);
        this.widgetButtonSize = this.DEFAULT_WIDGET_BUTTON_SIZE = 15;
    }

    public OverlayMapPanel(boolean delayCreation) {
        super((PropertyHandler)null, delayCreation);
        this.widgetButtonSize = this.DEFAULT_WIDGET_BUTTON_SIZE = 15;
    }

    public OverlayMapPanel(PropertyHandler propertyHandler) {
        super(propertyHandler, false);
        this.widgetButtonSize = this.DEFAULT_WIDGET_BUTTON_SIZE = 15;
    }

    public OverlayMapPanel(PropertyHandler propertyHandler, boolean delayCreation) {
        super(propertyHandler, delayCreation);
        this.widgetButtonSize = this.DEFAULT_WIDGET_BUTTON_SIZE = 15;
    }

    protected void addMapBeanToPanel(MapBean map) {
        this.layoutPanel(map);
    }

    public DrawingAttributes getActiveWidgetColors() {
        return this.activeWidgetColors;
    }

    public void setActiveWidgetColors(DrawingAttributes activeWidgetColors) {
        this.activeWidgetColors = activeWidgetColors;
    }

    public DrawingAttributes getInactiveWidgetColors() {
        return this.inactiveWidgetColors;
    }

    public void setInactiveWidgetColors(DrawingAttributes inactiveWidgetColors) {
        this.inactiveWidgetColors = inactiveWidgetColors;
    }

    public int getWidgetButtonSize() {
        return this.widgetButtonSize;
    }

    public void setWidgetButtonSize(int widgetButtonSize) {
        this.widgetButtonSize = widgetButtonSize;
    }

    protected void layoutPanel(MapBean map) {
        Dimension minimumSize = new Dimension(640, 480);
        JPanel centerContainer = new JPanel();
        JPanel hackPanel = new JPanel();
        hackPanel.setLayout(new BorderLayout());
        hackPanel.setOpaque(false);
        hackPanel.add((Component)map, "Center");
        centerContainer.setLayout(new OverlayLayout(centerContainer));
        DrawingAttributes activeWidgetColors = this.getActiveWidgetColors();
        DrawingAttributes inactiveWidgetColors = this.getInactiveWidgetColors();
        int widgetButtonSize = this.getWidgetButtonSize();
        EmbeddedNavPanel navPanel = new EmbeddedNavPanel(activeWidgetColors, inactiveWidgetColors, widgetButtonSize);
        navPanel.setBounds(12, 12, navPanel.getMinimumSize().width, navPanel.getMinimumSize().height);
        this.addMapComponent(navPanel);
        this.addMapComponent(new ProjectionStack());
        EmbeddedScaleDisplayPanel scaleDisplay = new EmbeddedScaleDisplayPanel();
        this.addMapComponent(scaleDisplay);
        this.widgets = new JPanel();
        this.widgets.setLayout(new BorderLayout());
        this.widgets.setBackground(OMGraphicConstants.clear);
        this.widgets.setOpaque(false);
        this.widgets.setBounds(0, 0, map.getWidth(), map.getHeight());
        this.widgets.setMinimumSize(minimumSize);
        this.widgets.add((Component)navPanel, "West");
        this.widgets.add((Component)scaleDisplay, "East");
        this.setBorders(map, this.widgets);
        centerContainer.add(this.widgets);
        centerContainer.add(hackPanel);
        this.add((Component)centerContainer, "Center");
    }

    protected void setBorders(MapBean map, JPanel widgets) {
        if (map != null) {
            map.setBorder(null);
        }
        if (widgets != null) {
            widgets.setBorder(BorderFactory.createBevelBorder(1, Color.GRAY, Color.DARK_GRAY));
        }
    }

    public void includeExitMenuItem() {
        this.addProperty("quitMenu.class", "com.bbn.openmap.gui.map.QuitMenuItem");
        this.appendProperty("fileMenu.items", "quitMenu");
    }

    public void setProperties(String prefix, Properties props) {
        DrawingAttributes iwc;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        DrawingAttributes awc = this.getActiveWidgetColors();
        if (awc == null) {
            awc = DrawingAttributes.getDefaultClone();
        }
        if ((iwc = this.getInactiveWidgetColors()) == null) {
            iwc = DrawingAttributes.getDefaultClone();
        }
        awc.setProperties(prefix + ACTIVE_WIDGET_COLOR_PROPERTY, props);
        if (awc.equals(DrawingAttributes.getDefaultClone())) {
            awc = null;
        }
        iwc.setProperties(prefix + INACTIVE_WIDGET_COLOR_PROPERTY, props);
        if (iwc.equals(DrawingAttributes.getDefaultClone())) {
            iwc = null;
        }
        this.setActiveWidgetColors(awc);
        this.setInactiveWidgetColors(iwc);
        this.setWidgetButtonSize(PropUtils.intFromProperties(props, prefix + WIDGET_SIZE_PROPERTY, this.getWidgetButtonSize()));
    }

    public Properties getProperties(Properties props) {
        int widgetSize;
        DrawingAttributes iwc;
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        DrawingAttributes awc = this.getActiveWidgetColors();
        if (awc != null) {
            awc.getProperties(props);
        }
        if ((iwc = this.getInactiveWidgetColors()) != null) {
            iwc.getProperties(props);
        }
        if ((widgetSize = this.getWidgetButtonSize()) != this.DEFAULT_WIDGET_BUTTON_SIZE) {
            props.put(prefix + WIDGET_SIZE_PROPERTY, Integer.toString(widgetSize));
        }
        return props;
    }

    public static void main(String[] argv) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame f = new JFrame("Map");
                f.setDefaultCloseOperation(3);
                OverlayMapPanel map = new OverlayMapPanel(new PropertyHandler(new Properties()), true);
                map.create();
                map.getMapBean().setBackgroundColor(new Color(10073036));
                map.addMapComponent(new LayerHandler());
                map.addMapComponent(new MouseDelegator());
                map.addMapComponent(new OMMouseMode());
                ShapeLayer shapeLayer = new ShapeLayer("share/data/shape/cntry02/cntry02.shp");
                map.addMapComponent(shapeLayer);
                map.includeExitMenuItem();
                f.setJMenuBar(map.getMapMenuBar());
                f.getContentPane().add(map);
                f.setSize(800, 600);
                f.setVisible(true);
            }
        });
    }
}

