/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Properties;

public abstract class OMToolComponent
extends OMComponentPanel
implements Tool {
    public static final String UseAsToolProperty = "isTool";
    public static final String defaultKey = "omtoolcomponent";
    protected String key = "omtoolcomponent";
    protected boolean useAsTool = true;
    protected GridBagLayout gridbag;
    protected GridBagConstraints c;

    public OMToolComponent() {
        this.setLayout(this.createLayout());
    }

    protected LayoutManager createLayout() {
        this.gridbag = new GridBagLayout();
        this.c = this.getGridBagConstraints();
        return this.gridbag;
    }

    protected GridBagConstraints getGridBagConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 2, 0, 2);
        return constraints;
    }

    public Component add(Component component) {
        this.gridbag.setConstraints(component, this.c);
        return super.add(component);
    }

    public Container getFace() {
        if (this.getUseAsTool()) {
            return this;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public void setUseAsTool(boolean value) {
        this.useAsTool = value;
    }

    public boolean getUseAsTool() {
        return this.useAsTool;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        if (prefix != null) {
            this.setKey(prefix);
        }
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setUseAsTool(PropUtils.booleanFromProperties(props, prefix + UseAsToolProperty, this.getUseAsTool()));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + UseAsToolProperty, new Boolean(this.useAsTool).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String internString = this.i18n.get(OMToolComponent.class, UseAsToolProperty, 3, "Whether this component should be added to the Tool Panel");
        props.put(UseAsToolProperty, internString);
        internString = this.i18n.get(OMToolComponent.class, UseAsToolProperty, "Add to Tool Panel");
        props.put("isTool.label", internString);
        props.put("isTool.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }
}

