/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoExtent;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.GeoSegment;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public interface ExtentIndex
extends Collection {
    public double indexHorizontalRange();

    public boolean addExtent(GeoExtent var1);

    public boolean removeExtent(GeoExtent var1);

    public void clear();

    public Iterator iterator(GeoExtent var1);

    public static class ArrayListExtentIndexImpl
    extends AbstractExtentIndex {
        public ArrayListExtentIndexImpl() {
            this(360, 0.0);
        }

        public ArrayListExtentIndexImpl(int nb) {
            this(nb, 0.0);
        }

        public ArrayListExtentIndexImpl(double m) {
            this(360, m);
        }

        public ArrayListExtentIndexImpl(int nb, double m) {
            super(nb, m);
        }

        protected Collection makeBucket(int sizeHint) {
            if (sizeHint != 0) {
                return new ArrayList();
            }
            return new ArrayList(sizeHint);
        }
    }

    public static class HashSetExtentIndexImpl
    extends AbstractExtentIndex {
        public HashSetExtentIndexImpl() {
            this(360, 0.0);
        }

        public HashSetExtentIndexImpl(int nb) {
            this(nb, 0.0);
        }

        public HashSetExtentIndexImpl(double m) {
            this(360, m);
        }

        public HashSetExtentIndexImpl(int nb, double m) {
            super(nb, m);
        }

        protected Collection makeBucket(int sizeHint) {
            if (sizeHint != 0) {
                return new HashSet();
            }
            return new HashSet(sizeHint);
        }
    }

    public static abstract class AbstractExtentIndex
    extends AbstractCollection
    implements ExtentIndex {
        public static final int D_NBUCKETS = 360;
        public static final double D_MARGIN = 0.0;
        public final int nbuckets;
        public final double margin;
        protected final Collection[] buckets;
        protected final Collection all;
        protected final Collection polar;
        protected final Collection discarded;

        public AbstractExtentIndex() {
            this(360, 0.0);
        }

        public AbstractExtentIndex(int nb) {
            this(nb, 0.0);
        }

        public AbstractExtentIndex(double m) {
            this(360, m);
        }

        public AbstractExtentIndex(int nb, double m) {
            this.nbuckets = nb;
            this.margin = m;
            this.buckets = new Collection[this.nbuckets];
            this.all = this.makeBucket(2000);
            this.polar = this.makeBucket();
            this.discarded = this.makeBucket();
        }

        protected final Collection makeBucket() {
            return this.makeBucket(0);
        }

        protected abstract Collection makeBucket(int var1);

        public boolean add(Object o) {
            if (o instanceof GeoExtent) {
                return this.addExtent((GeoExtent)o);
            }
            return false;
        }

        public boolean addExtent(GeoExtent extent) {
            boolean ret = false;
            try {
                BoundingCircle bc = extent.getBoundingCircle();
                if (bc == null) {
                    this.discarded.add(extent);
                    return false;
                }
                Geo center = bc.getCenter();
                double clon = center.getLongitude();
                double clat = center.getLatitude();
                double rnm = Geo.nm(bc.getRadius());
                if (clat == 90.0 && clon == -180.0 || rnm >= 5400.0) {
                    this.discarded.add(extent);
                } else {
                    this.all.add(extent);
                    double latfactor = Geo.npdAtLat(clat);
                    if (latfactor == 0.0) {
                        this.polar.add(extent);
                        ret = true;
                    } else {
                        double xd = (rnm + this.margin) / latfactor;
                        if (xd >= 45.0) {
                            this.polar.add(extent);
                            ret = true;
                        } else {
                            double[] lons = AbstractExtentIndex.normalizeLons(new double[]{clon - xd, clon + xd});
                            int lb = this.bucketFor(lons[0]);
                            int rb = this.bucketFor(lons[1]);
                            if (rb < lb) {
                                rb += this.nbuckets;
                            }
                            for (int i = lb; i <= rb; ++i) {
                                int x = i % this.nbuckets;
                                Collection b = this.buckets[x];
                                if (b == null) {
                                    this.buckets[x] = b = this.makeBucket(5);
                                }
                                b.add(extent);
                                ret = true;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        protected static final double normalizeLon(double lon) {
            double n = lon % 360.0;
            return n < 0.0 ? n + 360.0 : n;
        }

        protected final int bucketFor(double lon) {
            return (int)Math.floor(AbstractExtentIndex.normalizeLon(lon) / 360.0 * (double)this.nbuckets);
        }

        protected static final double[] normalizeLons(double[] lons) {
            double a = AbstractExtentIndex.normalizeLon(lons[0]);
            double b = AbstractExtentIndex.normalizeLon(lons[1]);
            if (Math.abs(b - a) > 180.0 == b > a) {
                lons[0] = b;
                lons[1] = a;
            } else {
                lons[0] = a;
                lons[1] = b;
            }
            return lons;
        }

        protected Iterator lookup(double left, double right) {
            return this.lookup(left, right, null);
        }

        protected Iterator lookup(double left, double right, BoundingCircle bc) {
            HashSet<GeoExtent> s = null;
            int lb = this.bucketFor(left);
            int rb = this.bucketFor(right);
            if (rb < lb) {
                rb += this.nbuckets;
            }
            for (int i = lb; i <= rb; ++i) {
                Collection b = this.buckets[i % this.nbuckets];
                if (b == null) continue;
                if (bc == null) {
                    if (s == null) {
                        s = new HashSet();
                    }
                    s.addAll(b);
                    continue;
                }
                for (GeoExtent region : b) {
                    if (!bc.intersects(region.getBoundingCircle())) continue;
                    if (s == null) {
                        s = new HashSet();
                    }
                    s.add(region);
                }
            }
            if (!this.polar.isEmpty()) {
                if (s == null) {
                    s = new HashSet<GeoExtent>();
                }
                s.addAll(this.polar);
            }
            if (s == null) {
                return Collections.EMPTY_SET.iterator();
            }
            return s.iterator();
        }

        public boolean removeExtent(GeoExtent region) {
            boolean ret = false;
            BoundingCircle bc = region.getBoundingCircle();
            if (bc == null) {
                return this.discarded.remove(region);
            }
            Geo center = bc.getCenter();
            double clon = center.getLongitude();
            double clat = center.getLatitude();
            double rnm = Geo.nm(bc.getRadius());
            if (clat == 90.0 && clon == -180.0 || rnm >= 5400.0) {
                this.discarded.remove(region);
            } else {
                this.all.remove(region);
                double latfactor = Geo.npdAtLat(clat);
                if (latfactor == 0.0) {
                    ret = ret || this.polar.remove(region);
                } else {
                    double xd = (rnm + this.margin) / latfactor;
                    if (xd >= 45.0) {
                        ret = ret || this.polar.remove(region);
                    } else {
                        double[] lons = AbstractExtentIndex.normalizeLons(new double[]{clon - xd, clon + xd});
                        int lb = this.bucketFor(lons[0]);
                        int rb = this.bucketFor(lons[1]);
                        if (rb < lb) {
                            rb += this.nbuckets;
                        }
                        for (int i = lb; i <= rb; ++i) {
                            int x = i % this.nbuckets;
                            Collection b = this.buckets[x];
                            if (b == null) continue;
                            boolean bl = ret = ret || b.remove(region);
                            if (!b.isEmpty()) continue;
                            this.buckets[x] = null;
                        }
                    }
                }
            }
            return ret;
        }

        public void clear() {
            this.all.clear();
            this.polar.clear();
            this.discarded.clear();
            for (int i = 0; i < this.buckets.length; ++i) {
                if (this.buckets[i] == null) continue;
                this.buckets[i].clear();
            }
        }

        public double indexHorizontalRange() {
            return this.margin;
        }

        public Iterator lookupBySegment(GeoSegment segment) {
            Geo[] pts = segment.getSeg();
            double[] lons = AbstractExtentIndex.normalizeLons(new double[]{pts[0].getLongitude(), pts[1].getLongitude()});
            return this.lookup(lons[0], lons[1], segment.getBoundingCircle());
        }

        public Iterator lookupByPath(GeoPath path) {
            HashSet results = null;
            GeoPath.SegmentIterator pit = path.segmentIterator();
            while (pit.hasNext()) {
                GeoSegment seg = pit.nextSegment();
                Iterator it = this.lookupBySegment(seg);
                while (it.hasNext()) {
                    if (results == null) {
                        results = new HashSet();
                    }
                    results.add(it.next());
                }
            }
            if (results == null) {
                return Collections.EMPTY_SET.iterator();
            }
            return results.iterator();
        }

        public Iterator lookupByBoundingCircle(BoundingCircle bc) {
            double cLon = bc.getCenter().getLongitude();
            double rNM = Geo.nm(bc.getRadius());
            double npd = Geo.npdAtLat(bc.getCenter().getLatitude());
            if (npd == 0.0) {
                return this.iterator();
            }
            double rdeg = rNM / npd;
            if (rdeg >= 180.0) {
                return this.iterator();
            }
            return this.lookup(cLon - rdeg, cLon + rdeg, bc);
        }

        public Iterator iterator(GeoExtent o) {
            if (o instanceof GeoSegment) {
                return this.lookupBySegment((GeoSegment)o);
            }
            if (o instanceof GeoRegion) {
                return this.lookupByBoundingCircle(o.getBoundingCircle());
            }
            if (o instanceof GeoPath) {
                return this.lookupByPath((GeoPath)o);
            }
            if (o instanceof GeoPoint) {
                return this.lookupByBoundingCircle(new BoundingCircle.Impl(((GeoPoint)o).getPoint(), 0.0));
            }
            return this.lookupByBoundingCircle(o.getBoundingCircle());
        }

        public Iterator iterator() {
            return this.all.iterator();
        }

        public int size() {
            return this.all.size();
        }

        public String toString() {
            int entc = 0;
            int empties = 0;
            for (int i = 0; i < this.nbuckets; ++i) {
                Collection l = this.buckets[i];
                if (l != null) {
                    entc += l.size();
                    continue;
                }
                ++empties;
            }
            return this.getClass().getName() + "[" + this.size() + " -" + this.discarded.size() + " E" + (float)entc / (float)this.nbuckets + "]";
        }
    }
}

