/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.beanbox;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.examples.beanbox.CustomGraphic;
import com.bbn.openmap.examples.beanbox.SimpleBeanBox;
import com.bbn.openmap.examples.beanbox.SimpleBeanObject;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.beanbox.BeanBox;
import com.bbn.openmap.tools.beanbox.BeanBoxHandler;
import java.awt.Graphics;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class SimpleBeanLayer
extends Layer
implements BeanBoxHandler {
    protected HashMap beans = new HashMap();
    protected HashMap graphics = new HashMap();
    protected Projection projection;
    protected SimpleBeanBox beanBox;
    private static SimpleBeanLayer thisLayer;

    public SimpleBeanLayer() {
        this.setName("Simple Bean Layer");
        this.addToBeanContext = true;
        thisLayer = this;
        this.beanBox = new SimpleBeanBox(this);
    }

    public static SimpleBeanLayer getLayer() {
        return thisLayer;
    }

    public BeanBox getBeanBox() {
        return this.beanBox;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public MapMouseListener getMapMouseListener() {
        return this.beanBox;
    }

    public void projectionChanged(ProjectionEvent event) {
        this.projection = event.getProjection();
        Collection values = this.graphics.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ((OMGraphic)iter.next()).generate(this.projection);
        }
    }

    public void paint(Graphics g) {
        Collection values = this.graphics.values();
        for (OMGraphic graphic : values) {
            graphic.render(g);
        }
    }

    public void updateGraphics() {
        Set keys = this.beans.keySet();
        for (Long id : keys) {
            SimpleBeanObject bean = (SimpleBeanObject)this.beans.get(id);
            OMGraphic graphic = (OMGraphic)this.graphics.get(id);
            if (graphic instanceof CustomGraphic) {
                ((CustomGraphic)graphic).updateGraphic(bean);
            } else if (graphic instanceof OMRasterObject) {
                ((OMRasterObject)graphic).setLat(bean.getLatitude());
                ((OMRasterObject)graphic).setLon(bean.getLongitude());
                ((OMRasterObject)graphic).setRotationAngle(Math.toRadians(bean.getBearingInDeg()));
            }
            graphic.setNeedToRegenerate(true);
            if (this.projection == null) continue;
            graphic.generate(this.projection);
        }
        this.repaint();
    }

    public void addObject(SimpleBeanObject object) {
        this.beans.put(new Long(object.getId()), object);
        String customGraphicClassName = object.getCustomGraphicClassName();
        OMGeometry graphic = null;
        if (customGraphicClassName == null) {
            ImageIcon icon = new ImageIcon(object.getGraphicImage());
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            graphic = new OMRaster((double)object.getLatitude(), (double)object.getLongitude(), -width / 2, -height / 2, icon);
            ((OMRaster)graphic).setRotationAngle(Math.toRadians(object.getBearingInDeg()));
            graphic.setRenderType(3);
            graphic.setAppObject(new Long(object.getId()));
        } else {
            try {
                Class<?> graphicClass;
                Class<?> parentClass;
                for (parentClass = graphicClass = Class.forName(customGraphicClassName); parentClass != null && parentClass != CustomGraphic.class; parentClass = parentClass.getSuperclass()) {
                }
                if (parentClass != null) {
                    Constructor<?> constructor = graphicClass.getConstructor(SimpleBeanObject.class);
                    graphic = (CustomGraphic)constructor.newInstance(object);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (graphic != null) {
            graphic.setNeedToRegenerate(true);
            this.graphics.put(new Long(object.getId()), graphic);
            if (this.projection != null) {
                graphic.generate(this.projection);
            }
            this.repaint();
        }
    }

    public void removeObject(Long id) {
        this.beans.remove(id);
        this.graphics.remove(id);
    }

    public void removeObject(long id) {
        this.removeObject(new Long(id));
    }

    public SimpleBeanObject getObject(Long id) {
        return (SimpleBeanObject)this.beans.get(id);
    }

    public SimpleBeanObject getObject(long id) {
        return (SimpleBeanObject)this.beans.get(new Long(id));
    }

    public Vector getObjects() {
        return new Vector(this.beans.values());
    }

    public OMGraphic getGraphic(Long id) {
        return (OMGraphic)this.graphics.get(id);
    }

    public OMGraphic getGraphic(long id) {
        return (OMGraphic)this.graphics.get(new Long(id));
    }

    public void updateObject(SimpleBeanObject object) {
        if (this.getObject(object.getId()) == null) {
            return;
        }
        this.removeObject(object.getId());
        this.addObject(object);
    }
}

