/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.geo.ExtentIndex;
import com.bbn.openmap.geo.GeoExtent;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.MatchCollector;
import com.bbn.openmap.geo.MatchFilter;
import com.bbn.openmap.geo.MatchParameters;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import java.net.URL;
import java.util.Iterator;

public class ShapeGeoIndex
extends ExtentIndex.ArrayListExtentIndexImpl {
    private ShapeGeoIndex(Builder builder) {
        super(builder.numberOfBuckets, builder.margin);
        EsriGraphicList graphicList = EsriGraphicList.getEsriGraphicList(builder.shapeFile, null, builder.geoCoordTransform);
        if (graphicList != null) {
            this.load(graphicList);
        }
    }

    public void load(EsriGraphicList list) {
        if (list != null) {
            int type = list.getType();
            switch (type) {
                case 1: 
                case 11: 
                case 21: {
                    this.loadPoints(list);
                    break;
                }
                case 5: 
                case 15: 
                case 25: {
                    this.loadPolygons(list);
                    break;
                }
                case 3: 
                case 13: 
                case 23: {
                    this.loadPolylines(list);
                    break;
                }
            }
        }
    }

    private void loadPoints(EsriGraphicList list) {
        for (OMGraphic omg : list) {
            if (omg instanceof OMGraphicList) {
                Object recNum = ((OMGraphicList)omg).getAttribute("SHAPE_INDEX_ATTRIBUTE");
                for (OMGraphic pnt : (OMGraphicList)omg) {
                    this.addPoint((OMPoint)pnt, recNum);
                }
                continue;
            }
            this.addPoint((OMPoint)omg, omg.getAttribute("SHAPE_INDEX_ATTRIBUTE"));
        }
    }

    private void addPoint(OMPoint omp, Object id) {
        double latitude = omp.getLat();
        double longitude = omp.getLon();
        GeoPoint.Impl geoPoint = new GeoPoint.Impl(latitude, longitude);
        geoPoint.setID(id);
        this.addExtent(geoPoint);
    }

    private void loadPolygons(EsriGraphicList list) {
        for (OMGraphic omg : list) {
            if (omg instanceof OMGraphicList) {
                Object recNum = ((OMGraphicList)omg).getAttribute("SHAPE_INDEX_ATTRIBUTE");
                for (OMGraphic poly : (OMGraphicList)omg) {
                    this.addPolygon((OMPoly)poly, recNum);
                }
                continue;
            }
            this.addPolygon((OMPoly)omg, omg.getAttribute("SHAPE_INDEX_ATTRIBUTE"));
        }
    }

    private void addPolygon(OMPoly omp, Object id) {
        double[] latlonArray = omp.getLatLonArray();
        GeoRegion.Impl region = new GeoRegion.Impl(latlonArray, false);
        region.setID(id);
        this.addExtent(region);
    }

    private void loadPolylines(EsriGraphicList list) {
        for (OMGraphic omg : list) {
            if (omg instanceof OMGraphicList) {
                Object recNum = ((OMGraphicList)omg).getAttribute("SHAPE_INDEX_ATTRIBUTE");
                for (OMGraphic pnt : (OMGraphicList)omg) {
                    this.addPolyline((OMPoly)pnt, recNum);
                }
                continue;
            }
            this.addPolyline((OMPoly)omg, omg.getAttribute("SHAPE_INDEX_ATTRIBUTE"));
        }
    }

    private void addPolyline(OMPoly omp, Object id) {
        double[] latlonArray = omp.getLatLonArray();
        GeoPath.Impl region = new GeoPath.Impl(latlonArray);
        region.setID(id);
        this.addExtent(region);
    }

    public Iterator getIntersections(GeoExtent extent) {
        return this.getIntersections(extent, new MatchFilter.MatchParametersMF(MatchParameters.STRICT), new MatchCollector.SetMatchCollector());
    }

    public Iterator getIntersections(GeoExtent extent, MatchFilter filter, MatchCollector collector) {
        Intersection intersection = Intersection.intersector();
        intersection.consider(extent, this);
        collector = intersection.getCollector();
        return collector.iterator();
    }

    public static class Builder {
        private URL shapeFile;
        private GeoCoordTransformation geoCoordTransform;
        private int numberOfBuckets = 360;
        private double margin = 0.0;

        public Builder(URL shape) {
            this.shapeFile = shape;
        }

        public Builder setGeoCoordTransformation(GeoCoordTransformation geoCoordTransformation) {
            this.geoCoordTransform = geoCoordTransformation;
            return this;
        }

        public Builder setNumberOfBuckets(int nBuckets) {
            this.numberOfBuckets = nBuckets;
            return this;
        }

        public Builder setMargin(double mar) {
            this.margin = mar;
            return this;
        }

        public ShapeGeoIndex create() {
            return new ShapeGeoIndex(this);
        }
    }
}

