/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DTEDFrameACC {
    public int abs_horz_acc = -1;
    public int abs_vert_acc = -1;
    public int rel_horz_acc = -1;
    public int rel_vert_acc = -1;

    public DTEDFrameACC(BinaryFile binFile) {
        try {
            binFile.seek(728L);
            binFile.readFixedLengthString(3);
            String s_abs_horz_acc = binFile.readFixedLengthString(4);
            try {
                if (s_abs_horz_acc.indexOf("NA") == -1 && s_abs_horz_acc.indexOf("N/A") == -1) {
                    this.abs_horz_acc = Integer.parseInt(s_abs_horz_acc, 10);
                }
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameACC: abs_horz_acc number bad, using 0");
                this.abs_horz_acc = 0;
            }
            String s_abs_vert_acc = binFile.readFixedLengthString(4);
            try {
                if (s_abs_vert_acc.indexOf("NA") == -1 && s_abs_vert_acc.indexOf("N/A") == -1) {
                    this.abs_vert_acc = Integer.parseInt(s_abs_vert_acc, 10);
                }
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameACC: abs_vert_acc number bad, using 0");
                this.abs_vert_acc = 0;
            }
            String s_rel_horz_acc = binFile.readFixedLengthString(4);
            try {
                if (s_rel_horz_acc.indexOf("NA") == -1 && s_rel_horz_acc.indexOf("N/A") == -1) {
                    this.rel_horz_acc = Integer.parseInt(s_rel_horz_acc, 10);
                }
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameACC: rel_horz_acc number bad, using 0");
                this.rel_horz_acc = 0;
            }
            String s_rel_vert_acc = binFile.readFixedLengthString(4);
            try {
                if (s_rel_vert_acc.indexOf("NA") == -1 && s_rel_vert_acc.indexOf("N/A") == -1) {
                    this.rel_vert_acc = Integer.parseInt(s_rel_vert_acc, 10);
                }
            }
            catch (NumberFormatException pExp) {
                Debug.message("dted", "DTEDFrameACC: rel_vert_acc number bad, using 0");
                this.rel_vert_acc = 0;
            }
        }
        catch (IOException e) {
            Debug.error("DTEDFrameACC: File IO Error!\n" + e.toString());
        }
        catch (FormatException f) {
            Debug.error("DTEDFrameACC: File IO Format error!\n" + f.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("***ACC***").append("\n");
        s.append("  abs_horz_acc: ").append(this.abs_horz_acc).append("\n");
        s.append("  abs_vert_acc: ").append(this.abs_vert_acc).append("\n");
        s.append("  rel_horz_acc: ").append(this.rel_horz_acc).append("\n");
        s.append("  rel_vert_acc: ").append(this.rel_vert_acc).append("\n");
        return s.toString();
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("dtedframe_acc:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameACC: using frame " + args[0]);
        File file = new File(args[0]);
        try {
            BinaryBufferedFile binFile = new BinaryBufferedFile(file);
            DTEDFrameACC dfa = new DTEDFrameACC(binFile);
            Debug.output(dfa.toString());
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrameACC: file " + args[0] + " not found");
            System.exit(-1);
        }
        catch (IOException e) {
            Debug.error("DTEDFrameACC: File IO Error!\n" + e.toString());
        }
    }
}

