/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import com.basho.riak.client.util.BranchableInputStream;
import com.basho.riak.client.util.Multipart;
import com.basho.riak.client.util.OneTokenInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamedMultipart
implements Iterator<Multipart.Part> {
    Map<String, String> headers = null;
    BranchableInputStream stream;
    String boundary;
    boolean foundNext = false;
    BranchableInputStream currentPartStream = null;

    public StreamedMultipart(Map<String, String> headers, InputStream stream) throws IOException, EOFException {
        if (headers == null || stream == null) {
            throw new IllegalArgumentException();
        }
        String initialBoundary = "--" + Multipart.getBoundary(headers.get("content-type"));
        String boundary = "\r\n" + initialBoundary;
        StringBuilder sb = new StringBuilder();
        do {
            int c;
            if ((c = stream.read()) == -1) {
                throw new EOFException();
            }
            sb.append((char)c);
        } while ((sb.length() != initialBoundary.length() || !initialBoundary.equals(sb.toString())) && sb.indexOf(boundary, sb.length() - boundary.length()) < 0);
        this.finishReadingLine(stream);
        this.headers = headers;
        this.boundary = boundary;
        this.stream = new BranchableInputStream(new OneTokenInputStream(stream, boundary + "--"));
    }

    private void finishReadingLine(InputStream in) throws IOException {
        int c;
        while ((c = in.read()) != -1 && c != 10) {
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean hasNext() {
        if (this.foundNext) {
            return true;
        }
        try {
            this.foundNext = this.findNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.foundNext;
    }

    @Override
    public Multipart.Part next() {
        if (!this.hasNext()) {
            return null;
        }
        this.foundNext = false;
        String headerBlock = null;
        try {
            headerBlock = this.readHeaderBlock(this.currentPartStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<String, String> headers = Multipart.parseHeaders(headerBlock);
        return new Multipart.Part(headers, this.currentPartStream.branch());
    }

    @Override
    public void remove() {
    }

    private boolean findNext() throws IOException {
        if (this.currentPartStream != null) {
            InputStream is = this.currentPartStream.branch();
            try {
                while (is.read() != -1) {
                }
                this.finishReadingLine(this.stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.stream.peek() != -1) {
            this.currentPartStream = new BranchableInputStream(new OneTokenInputStream(this.stream.branch(), this.boundary));
            return true;
        }
        return false;
    }

    private String readHeaderBlock(InputStream in) throws IOException {
        int c;
        StringBuilder headers = new StringBuilder();
        boolean currentLineEmpty = true;
        while (!((c = in.read()) == -1 || currentLineEmpty && c == 10)) {
            if (c == 10) {
                currentLineEmpty = true;
            } else if (c != 13 && c != 10) {
                currentLineEmpty = false;
            }
            headers.append((char)c);
        }
        return headers.toString();
    }
}

