/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import com.basho.riak.client.util.ClientUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipart {
    private static String HEADER_DELIM = "\r\n\r\n";

    public static List<Part> parse(Map<String, String> headers, String body) {
        if (headers == null || body == null || body.length() == 0) {
            return null;
        }
        if (!body.startsWith("\r\n")) {
            body = "\r\n" + body;
        }
        String boundary = "\r\n--" + Multipart.getBoundary(headers.get("content-type"));
        int boundarySize = boundary.length();
        if ("\r\n--".equals(boundary)) {
            return null;
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        int pos = body.indexOf(boundary);
        if (pos != -1) {
            while (pos < body.length()) {
                int start = pos + boundarySize;
                int end = body.indexOf(boundary, start);
                int headerEnd = body.indexOf(HEADER_DELIM, pos);
                int bodyStart = headerEnd + HEADER_DELIM.length();
                if (body.substring(start).startsWith("--")) break;
                if (end == -1) {
                    end = body.length();
                }
                if (headerEnd == -1) {
                    headerEnd = body.length();
                    bodyStart = end;
                }
                if (bodyStart > end) {
                    bodyStart = end;
                }
                Map<String, String> partHeaders = Multipart.parseHeaders(body.substring(start, headerEnd));
                String partBody = body.substring(bodyStart, end);
                parts.add(new Part(partHeaders, partBody.getBytes()));
                pos = end;
            }
        }
        return parts;
    }

    public static Map<String, String> parseHeaders(String s) {
        s.replaceAll("\r\n\\s+", " ");
        String[] headers = s.split("\r\n");
        HashMap<String, String> parsedHeaders = new HashMap<String, String>();
        for (String header : headers) {
            String[] nv = header.split("\\s*:\\s*", 2);
            if (nv.length <= 1) continue;
            parsedHeaders.put(nv[0].trim().toLowerCase(), nv[1].trim());
        }
        return parsedHeaders;
    }

    public static String getBoundary(String contentType) {
        String[] params;
        for (String param : params = contentType.split("\\s*;\\s*")) {
            String[] nv = param.split("\\s*=\\s*", 2);
            if (nv.length <= 1 || !"boundary".equals(nv[0].toLowerCase())) continue;
            return ClientUtils.unquoteString(nv[1]);
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Part {
        private Map<String, String> headers;
        private byte[] body;
        private InputStream stream;

        public Part(Map<String, String> headers, byte[] body) {
            this.headers = headers;
            this.body = body;
        }

        public Part(Map<String, String> headers, InputStream body) {
            this.headers = headers;
            this.stream = body;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public byte[] getBody() {
            if (this.body == null && this.stream != null) {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int readCount = 0;
                    while (readCount != -1) {
                        os.write(buffer, 0, readCount);
                        readCount = this.stream.read(buffer);
                    }
                    this.body = os.toByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
            return this.body;
        }

        public String getBodyAsString() {
            byte[] body = this.getBody();
            if (body == null) {
                return null;
            }
            return new String(body);
        }

        public InputStream getStream() {
            if (this.stream == null && this.body != null) {
                this.stream = new ByteArrayInputStream(this.body);
            }
            return this.stream;
        }
    }
}

