/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import com.basho.riak.client.RiakClient;
import com.basho.riak.client.RiakConfig;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.RiakObject;
import com.basho.riak.client.util.CheckedThrower;
import com.basho.riak.client.util.LinkHeader;
import com.basho.riak.client.util.Multipart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUtils {
    private static String URL_PATH_MASK = "^(?:[A-Za-z0-9+-\\.]+://)?[^/]*";

    public static HttpClient newHttpClient(RiakConfig config) {
        HttpConnectionManager m;
        HttpClient http = config.getHttpClient();
        if (http == null) {
            m = new MultiThreadedHttpConnectionManager();
            http = new HttpClient(m);
        } else {
            m = http.getHttpConnectionManager();
        }
        HttpConnectionManagerParams mp = m.getParams();
        if (config.getMaxConnections() != null) {
            mp.setMaxTotalConnections(config.getMaxConnections().intValue());
        }
        HttpClientParams cp = http.getParams();
        if (config.getTimeout() != null) {
            mp.setConnectionTimeout(config.getTimeout().intValue());
            cp.setConnectionManagerTimeout((long)config.getTimeout().intValue());
            cp.setSoTimeout(config.getTimeout().intValue());
        }
        if (config.getRetryHandler() != null) {
            cp.setParameter("http.method.retry-handler", (Object)config.getRetryHandler());
        }
        return http;
    }

    public static String makeURI(RiakConfig config, String bucket) {
        return config.getUrl() + "/" + ClientUtils.urlEncode(bucket);
    }

    public static String makeURI(RiakConfig config, String bucket, String key) {
        if (key == null) {
            return ClientUtils.makeURI(config, bucket);
        }
        return ClientUtils.makeURI(config, bucket) + "/" + ClientUtils.urlEncode(key);
    }

    public static String makeURI(RiakConfig config, String bucket, String key, String extra) {
        if (extra == null) {
            return ClientUtils.makeURI(config, bucket, key);
        }
        if (!extra.startsWith("?") && !extra.startsWith("/")) {
            extra = "/" + extra;
        }
        return ClientUtils.makeURI(config, bucket, key) + extra;
    }

    public static String getPathFromUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceFirst(URL_PATH_MASK, "");
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unreached) {
            throw new IllegalStateException("UTF-8 must be supported", unreached);
        }
    }

    public static String encodeClientId(byte[] clientId) {
        if (clientId == null || clientId.length < 4) {
            throw new IllegalArgumentException("ClientId must be at least 4 bytes");
        }
        try {
            return new String(Base64.encodeBase64((byte[])new byte[]{clientId[0], clientId[1], clientId[2], clientId[3]}), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 support is required by JVM");
        }
    }

    public static String encodeClientId(String clientId) {
        return ClientUtils.encodeClientId(clientId.getBytes());
    }

    public static String randomClientId() {
        byte[] rnd = new byte[4];
        new Random().nextBytes(rnd);
        return ClientUtils.encodeClientId(rnd);
    }

    public static String unquoteString(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s.replaceAll("\\\\(.)", "$1");
    }

    public static Map<String, String> asHeaderMap(Header[] headers) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (headers != null) {
            for (Header header : headers) {
                m.put(header.getName().toLowerCase(), header.getValue());
            }
        }
        return m;
    }

    public static Map<String, String> jsonObjectAsMap(JSONObject json) {
        if (json == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null) continue;
            String key = obj.toString();
            m.put(key, json.optString(key));
        }
        return m;
    }

    public static List<String> jsonArrayAsList(JSONArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < json.length(); ++i) {
            l.add(json.optString(i));
        }
        return l;
    }

    public static String join(String[] arr, String delimiter) {
        String res = null;
        if (arr == null || arr.length == 0) {
            return res;
        }
        res = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            res = res + delimiter + arr[i];
        }
        return res;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readCount);
        }
    }

    public static List<RiakLink> parseLinkHeader(String header) {
        ArrayList<RiakLink> links = new ArrayList<RiakLink>();
        Map<String, Map<String, String>> parsedLinks = LinkHeader.parse(header);
        for (String url : parsedLinks.keySet()) {
            RiakLink link = ClientUtils.parseOneLink(url, parsedLinks.get(url));
            if (link == null) continue;
            links.add(link);
        }
        return links;
    }

    private static RiakLink parseOneLink(String url, Map<String, String> params) {
        String[] parts;
        String tag = params.get("riaktag");
        if (tag != null && (parts = url.split("/")).length >= 2) {
            return new RiakLink(parts[parts.length - 2], parts[parts.length - 1], tag);
        }
        return null;
    }

    public static Map<String, String> parseUsermeta(Map<String, String> headers) {
        HashMap<String, String> usermeta = new HashMap<String, String>();
        if (headers != null) {
            for (String header : headers.keySet()) {
                if (header == null || !header.toLowerCase().startsWith("x-riak-meta-")) continue;
                usermeta.put(header.substring("x-riak-meta-".length()), headers.get(header));
            }
        }
        return usermeta;
    }

    public static List<RiakObject> parseMultipart(RiakClient riak, String bucket, String key, Map<String, String> docHeaders, String docBody) {
        String vclock = null;
        if (docHeaders != null) {
            vclock = docHeaders.get("x-riak-vclock");
        }
        List<Multipart.Part> parts = Multipart.parse(docHeaders, docBody);
        ArrayList<RiakObject> objects = new ArrayList<RiakObject>();
        if (parts != null) {
            for (Multipart.Part part : parts) {
                String[] locationParts;
                Map<String, String> headers = part.getHeaders();
                List<RiakLink> links = ClientUtils.parseLinkHeader(headers.get("link"));
                Map<String, String> usermeta = ClientUtils.parseUsermeta(headers);
                String location = headers.get("location");
                String partBucket = bucket;
                String partKey = key;
                if (location != null && (locationParts = location.split("/")).length >= 2) {
                    partBucket = locationParts[locationParts.length - 2];
                    partKey = locationParts[locationParts.length - 1];
                }
                RiakObject o = new RiakObject(riak, partBucket, partKey, part.getBody(), headers.get("content-type"), links, usermeta, vclock, headers.get("last-modified"), headers.get("etag"));
                objects.add(o);
            }
        }
        return objects;
    }

    public static void throwChecked(Throwable exception) {
        new CheckedThrower().throwChecked(exception);
    }
}

