/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client;

import com.basho.riak.client.RiakClient;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.request.RequestMeta;
import com.basho.riak.client.request.RiakWalkSpec;
import com.basho.riak.client.response.FetchResponse;
import com.basho.riak.client.response.HttpResponse;
import com.basho.riak.client.response.StoreResponse;
import com.basho.riak.client.response.WalkResponse;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakObject {
    private RiakClient riak;
    private String bucket;
    private String key;
    private byte[] value;
    private List<RiakLink> links;
    private Map<String, String> usermeta;
    private String contentType;
    private String vclock;
    private String lastmod;
    private String vtag;
    private InputStream valueStream;
    private Long valueStreamLength;

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> usermeta, String vclock, String lastmod, String vtag) {
        this.riak = riak;
        this.bucket = bucket;
        this.key = key;
        this.vclock = vclock;
        this.lastmod = lastmod;
        this.vtag = vtag;
        this.setValue(value);
        this.setContentType(contentType);
        this.setLinks(links);
        this.setUsermeta(usermeta);
    }

    public RiakObject(RiakClient riak, String bucket, String key) {
        this(riak, bucket, key, null, null, null, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value) {
        this(riak, bucket, key, value, null, null, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType) {
        this(riak, bucket, key, value, contentType, null, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links) {
        this(riak, bucket, key, value, contentType, links, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> usermeta) {
        this(riak, bucket, key, value, contentType, links, usermeta, null, null, null);
    }

    public RiakObject(String bucket, String key) {
        this(null, bucket, key, null, null, null, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value) {
        this(null, bucket, key, value, null, null, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType) {
        this(null, bucket, key, value, contentType, null, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType, List<RiakLink> links) {
        this(null, bucket, key, value, contentType, links, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> usermeta) {
        this(null, bucket, key, value, contentType, links, usermeta, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> usermeta, String vclock, String lastmod, String vtag) {
        this(null, bucket, key, value, contentType, links, usermeta, vclock, lastmod, vtag);
    }

    public RiakClient getRiakClient() {
        return this.riak;
    }

    public RiakObject setRiakClient(RiakClient client) {
        this.riak = client;
        return this;
    }

    public void copyData(RiakObject object) {
        if (object == null) {
            return;
        }
        this.value = (byte[])(object.value != null ? Arrays.copyOf(object.value, object.value.length) : null);
        this.valueStream = object.valueStream;
        this.valueStreamLength = object.valueStreamLength;
        this.links = new ArrayList<RiakLink>();
        if (object.links != null) {
            for (RiakLink link : object.links) {
                this.links.add(new RiakLink(link));
            }
        }
        this.usermeta = new HashMap<String, String>();
        if (object.usermeta != null) {
            this.usermeta.putAll(object.usermeta);
        }
        this.contentType = object.contentType;
        this.vclock = object.vclock;
        this.lastmod = object.lastmod;
        this.vtag = object.vtag;
    }

    void shallowCopy(RiakObject object) {
        this.value = object.value;
        this.links = object.links;
        this.usermeta = object.usermeta;
        this.contentType = object.contentType;
        this.vclock = object.vclock;
        this.lastmod = object.lastmod;
        this.vtag = object.vtag;
        this.valueStream = object.valueStream;
        this.valueStreamLength = object.valueStreamLength;
    }

    public void updateMeta(StoreResponse response) {
        if (response == null) {
            this.vclock = null;
            this.lastmod = null;
            this.vtag = null;
        } else {
            this.vclock = response.getVclock();
            this.lastmod = response.getLastmod();
            this.vtag = response.getVtag();
        }
    }

    public void updateMeta(FetchResponse response) {
        if (response == null || response.getObject() == null) {
            this.vclock = null;
            this.lastmod = null;
            this.vtag = null;
        } else {
            this.vclock = response.getObject().getVclock();
            this.lastmod = response.getObject().getLastmod();
            this.vtag = response.getObject().getVtag();
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value == null ? null : new String(this.value);
    }

    public byte[] getValueAsBytes() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = (byte[])(value != null ? value.getBytes() : null);
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setValueStream(InputStream in, Long len) {
        this.valueStream = in;
        this.valueStreamLength = len;
    }

    public void setValueStream(InputStream in) {
        this.valueStream = in;
    }

    public InputStream getValueStream() {
        return this.valueStream;
    }

    public void setValueStreamLength(Long len) {
        this.valueStreamLength = len;
    }

    public Long getValueStreamLength() {
        return this.valueStreamLength;
    }

    public List<RiakLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<RiakLink> links) {
        if (links == null) {
            links = new ArrayList<RiakLink>();
        }
        this.links = links;
    }

    public RiakObject addLink(RiakLink link) {
        if (link != null) {
            this.links.add(link);
        }
        return this;
    }

    public Map<String, String> getUsermeta() {
        return this.usermeta;
    }

    public void setUsermeta(Map<String, String> usermeta) {
        if (usermeta == null) {
            usermeta = new HashMap<String, String>();
        }
        this.usermeta = usermeta;
    }

    public RiakObject addUsermeta(String key, String value) {
        this.usermeta.put(key, value);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType != null ? contentType : "application/octet-stream";
    }

    public String getVclock() {
        return this.vclock;
    }

    public String getLastmod() {
        return this.lastmod;
    }

    public Date getLastmodAsDate() {
        try {
            return DateUtil.parseDate((String)this.lastmod);
        }
        catch (DateParseException e) {
            return null;
        }
    }

    public String getVtag() {
        return this.vtag;
    }

    public StoreResponse store(RequestMeta meta) {
        return this.store(this.riak, meta);
    }

    public StoreResponse store() {
        return this.store(this.riak, null);
    }

    public StoreResponse store(RiakClient riak, RequestMeta meta) {
        if (riak == null) {
            throw new IllegalStateException("Cannot store an object without a RiakClient");
        }
        StoreResponse r = riak.store(this, meta);
        if (r.isSuccess()) {
            this.updateMeta(r);
        }
        return r;
    }

    public FetchResponse fetch(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot fetch an object without a RiakClient");
        }
        FetchResponse r = this.riak.fetch(this.bucket, this.key, meta);
        if (r.getObject() != null) {
            RiakObject other = r.getObject();
            this.shallowCopy(other);
            r.setObject(this);
        }
        return r;
    }

    public FetchResponse fetch() {
        return this.fetch(null);
    }

    public FetchResponse fetchMeta(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot fetch meta for an object without a RiakClient");
        }
        FetchResponse r = this.riak.fetchMeta(this.bucket, this.key, meta);
        if (r.isSuccess()) {
            this.updateMeta(r);
        }
        return r;
    }

    public FetchResponse fetchMeta() {
        return this.fetchMeta(null);
    }

    public HttpResponse delete(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot delete an object without a RiakClient");
        }
        return this.riak.delete(this.bucket, this.key, meta);
    }

    public HttpResponse delete() {
        return this.delete(null);
    }

    public LinkBuilder walk(String bucket, String tag, boolean keep) {
        return new LinkBuilder().walk(bucket, tag, keep);
    }

    public LinkBuilder walk(String bucket, String tag) {
        return new LinkBuilder().walk(bucket, tag);
    }

    public LinkBuilder walk(String bucket, boolean keep) {
        return new LinkBuilder().walk(bucket, keep);
    }

    public LinkBuilder walk(String bucket) {
        return new LinkBuilder().walk(bucket);
    }

    public LinkBuilder walk() {
        return new LinkBuilder().walk();
    }

    public LinkBuilder walk(boolean keep) {
        return new LinkBuilder().walk(keep);
    }

    public void writeToHttpMethod(HttpMethod httpMethod) {
        String basePath = this.getBasePathFromHttpMethod(httpMethod);
        StringBuilder linkHeader = new StringBuilder();
        for (RiakLink link : this.links) {
            if (linkHeader.length() > 0) {
                linkHeader.append(", ");
            }
            linkHeader.append("<");
            linkHeader.append(basePath);
            linkHeader.append("/");
            linkHeader.append(link.getBucket());
            linkHeader.append("/");
            linkHeader.append(link.getKey());
            linkHeader.append(">; ");
            linkHeader.append("riaktag");
            linkHeader.append("=\"");
            linkHeader.append(link.getTag());
            linkHeader.append("\"");
        }
        if (linkHeader.length() > 0) {
            httpMethod.setRequestHeader("link", linkHeader.toString());
        }
        for (String name : this.usermeta.keySet()) {
            httpMethod.setRequestHeader("X-Riak-Meta-" + name, this.usermeta.get(name));
        }
        if (this.vclock != null) {
            httpMethod.setRequestHeader("x-riak-vclock", this.vclock);
        }
        if (httpMethod instanceof EntityEnclosingMethod) {
            EntityEnclosingMethod entityEnclosingMethod = (EntityEnclosingMethod)httpMethod;
            if (this.valueStream != null) {
                if (this.valueStreamLength != null && this.valueStreamLength >= 0L) {
                    entityEnclosingMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(this.valueStream, this.valueStreamLength.longValue(), this.contentType));
                } else {
                    entityEnclosingMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(this.valueStream, this.contentType));
                }
            } else if (this.value != null) {
                entityEnclosingMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.value, this.contentType));
            } else {
                entityEnclosingMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("".getBytes(), this.contentType));
            }
        }
    }

    String getBasePathFromHttpMethod(HttpMethod httpMethod) {
        if (httpMethod == null || httpMethod.getPath() == null) {
            return "";
        }
        String path = httpMethod.getPath();
        int idx = path.length() - 1;
        if (path.endsWith("/")) {
            --idx;
        }
        idx = path.lastIndexOf(47, idx);
        if ((idx = path.lastIndexOf(47, idx - 1)) <= 0) {
            return "";
        }
        return path.substring(0, idx);
    }

    public class LinkBuilder {
        private RiakWalkSpec walkSpec = new RiakWalkSpec();

        public LinkBuilder walk() {
            this.walkSpec.addStep("_", "_");
            return this;
        }

        public LinkBuilder walk(boolean keep) {
            this.walkSpec.addStep("_", "_", keep);
            return this;
        }

        public LinkBuilder walk(String bucket) {
            this.walkSpec.addStep(bucket, "_");
            return this;
        }

        public LinkBuilder walk(String bucket, boolean keep) {
            this.walkSpec.addStep(bucket, "_", keep);
            return this;
        }

        public LinkBuilder walk(String bucket, String tag) {
            this.walkSpec.addStep(bucket, tag);
            return this;
        }

        public LinkBuilder walk(String bucket, String tag, boolean keep) {
            this.walkSpec.addStep(bucket, tag, keep);
            return this;
        }

        public String getWalkSpec() {
            return this.walkSpec.toString();
        }

        public WalkResponse run(RequestMeta meta) {
            if (RiakObject.this.riak == null) {
                throw new IllegalStateException("Cannot perform object link walk without a RiakClient");
            }
            return RiakObject.this.riak.walk(RiakObject.this.bucket, RiakObject.this.key, this.getWalkSpec(), meta);
        }

        public WalkResponse run() {
            return this.run(null);
        }
    }
}

