/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.spring.cloud.config.AppConfigurationRefresh;
import com.azure.spring.cloud.config.health.AppConfigurationStoreHealth;
import com.azure.spring.cloud.config.implementation.AppConfigurationRefreshUtil;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.config.implementation.StateHolder;
import com.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AppConfigurationPullRefresh
implements AppConfigurationRefresh {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPullRefresh.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private final Long defaultMinBackoff;
    private final AppConfigurationReplicaClientFactory clientFactory;
    private final Duration refreshInterval;

    public AppConfigurationPullRefresh(AppConfigurationReplicaClientFactory clientFactory, Duration refreshInterval, Long defaultMinBackoff) {
        this.defaultMinBackoff = defaultMinBackoff;
        this.refreshInterval = refreshInterval;
        this.clientFactory = clientFactory;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @Override
    @Async
    public Future<Boolean> refreshConfigurations() {
        return new AsyncResult((Object)this.refreshStores());
    }

    @Override
    public void expireRefreshInterval(String endpoint, String syncToken) {
        LOGGER.debug("Expiring refresh interval for " + endpoint);
        String originEndpoint = this.clientFactory.findOriginForEndpoint(endpoint);
        this.clientFactory.updateSyncToken(originEndpoint, endpoint, syncToken);
        StateHolder.getCurrentState().expireState(originEndpoint);
    }

    private boolean refreshStores() {
        if (this.running.compareAndSet(false, true)) {
            BaseAppConfigurationPolicy.setWatchRequests(true);
            try {
                AppConfigurationRefreshUtil.RefreshEventData eventData = AppConfigurationRefreshUtil.refreshStoresCheck(this.clientFactory, this.refreshInterval, this.defaultMinBackoff);
                if (eventData.getDoRefresh()) {
                    this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                StateHolder.getCurrentState().updateNextRefreshTime(this.refreshInterval, this.defaultMinBackoff);
                throw e;
            }
            finally {
                this.running.set(false);
            }
        }
        return false;
    }

    @Override
    public Map<String, AppConfigurationStoreHealth> getAppConfigurationStoresHealth() {
        return this.clientFactory.getHealth();
    }
}

