// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The PageRange model.
 */
@Fluent
public final class PageRange implements XmlSerializable<PageRange> {
    /*
     * The Start property.
     */
    private long start;

    /*
     * The End property.
     */
    private long end;

    /**
     * Creates an instance of PageRange class.
     */
    public PageRange() {
    }

    /**
     * Get the start property: The Start property.
     * 
     * @return the start value.
     */
    public long getStart() {
        return this.start;
    }

    /**
     * Set the start property: The Start property.
     * 
     * @param start the start value to set.
     * @return the PageRange object itself.
     */
    public PageRange setStart(long start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: The End property.
     * 
     * @return the end value.
     */
    public long getEnd() {
        return this.end;
    }

    /**
     * Set the end property: The End property.
     * 
     * @param end the end value to set.
     * @return the PageRange object itself.
     */
    public PageRange setEnd(long end) {
        this.end = end;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageRange" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("Start", this.start);
        xmlWriter.writeLongElement("End", this.end);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of PageRange from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of PageRange if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the PageRange.
     */
    public static PageRange fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of PageRange from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of PageRange if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the PageRange.
     */
    public static PageRange fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageRange" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageRange deserializedPageRange = new PageRange();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedPageRange.start = reader.getLongElement();
                } else if ("End".equals(elementName.getLocalPart())) {
                    deserializedPageRange.end = reader.getLongElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedPageRange;
        });
    }
}
