/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.cryptography.KeyEncryptionKey;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClientBuilder;

@ServiceClient(builder=KeyEncryptionKeyClientBuilder.class)
public final class KeyEncryptionKeyClient
implements KeyEncryptionKey {
    private final KeyEncryptionKeyAsyncClient client;

    KeyEncryptionKeyClient(KeyEncryptionKeyAsyncClient client) {
        this.client = client;
    }

    public String getKeyId() {
        return (String)this.client.getKeyId().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] wrapKey(String algorithm, byte[] key) {
        return (byte[])this.client.wrapKey(algorithm, key).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] unwrapKey(String algorithm, byte[] encryptedKey) {
        return (byte[])this.client.unwrapKey(algorithm, encryptedKey).block();
    }

    KeyEncryptionKeyAsyncClient getKeyEncryptionKeyAsyncClient() {
        return this.client;
    }
}

