/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.OnBehalfOfCredential;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.HashMap;
import java.util.Map;

public class OnBehalfOfCredentialBuilder
extends AadCredentialBuilderBase<OnBehalfOfCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(OnBehalfOfCredentialBuilder.class);
    private String clientSecret;
    private String clientCertificatePath;
    private String clientCertificatePassword;

    public OnBehalfOfCredentialBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OnBehalfOfCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public OnBehalfOfCredentialBuilder pemCertificate(String pemCertificatePath) {
        this.clientCertificatePath = pemCertificatePath;
        return this;
    }

    public OnBehalfOfCredentialBuilder pfxCertificate(String pfxCertificatePath) {
        this.clientCertificatePath = pfxCertificatePath;
        return this;
    }

    public OnBehalfOfCredentialBuilder clientCertificatePassword(String clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public OnBehalfOfCredentialBuilder sendCertificateChain(boolean sendCertificateChain) {
        this.identityClientOptions.setIncludeX5c(sendCertificateChain);
        return this;
    }

    public OnBehalfOfCredentialBuilder userAssertion(String userAssertion) {
        this.identityClientOptions.userAssertion(userAssertion);
        return this;
    }

    public OnBehalfOfCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", OnBehalfOfCredentialBuilder.this.clientId);
                this.put("tenantId", OnBehalfOfCredentialBuilder.this.tenantId);
            }
        }, LOGGER);
        if (this.clientSecret == null && this.clientCertificatePath == null) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("At least client secret or certificate path should provided in OnBehalfOfCredentialBuilder. Only one of them should be provided."));
        }
        if (this.clientCertificatePath != null && this.clientSecret != null) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Both client secret and certificate path are provided in OnBehalfCredentialBuilder. Only one of them should be provided."));
        }
        return new OnBehalfOfCredential(this.clientId, this.tenantId, this.clientSecret, this.clientCertificatePath, this.clientCertificatePassword, this.identityClientOptions);
    }
}

