/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;

public final class ValidationUtil {
    private static Pattern clientIdentifierCharPattern = Pattern.compile("^(?:[A-Z]|[0-9]|[a-z]|-)+$");
    private static Pattern tenantIdentifierCharPattern = Pattern.compile("^(?:[A-Z]|[0-9]|[a-z]|-|.)+$");

    public static void validate(String className, Map<String, Object> parameters) {
        ClientLogger logger = new ClientLogger(className);
        ArrayList<String> missing = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() != null) continue;
            missing.add(entry.getKey());
        }
        if (missing.size() > 0) {
            throw logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Must provide non-null values for " + String.join((CharSequence)", ", missing) + " properties in " + className));
        }
    }

    public static void validateAuthHost(String className, String authHost) {
        ClientLogger logger = new ClientLogger(className);
        try {
            new URI(authHost);
        }
        catch (URISyntaxException e) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Must provide a valid URI for authority host.", e));
        }
        if (!authHost.startsWith("https")) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Authority host must use https scheme."));
        }
    }

    public static void validateClientIdCharacterRange(String className, String id) {
        ClientLogger logger = new ClientLogger(className);
        if (id != null && !clientIdentifierCharPattern.matcher(id).matches()) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Client id must have characters in the range of [A-Z], [0-9], [a-z], '-'"));
        }
    }

    public static void validateTenantIdCharacterRange(String className, String id) {
        ClientLogger logger = new ClientLogger(className);
        if (id != null && !tenantIdentifierCharPattern.matcher(id).matches()) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Tenant id must have characters in the range of [A-Z], [0-9], [a-z], '-', '.'"));
        }
    }

    public static void validateFilePath(String className, String filePath, String pathName) {
        Path normalizedPath;
        Path absolutePath;
        File file;
        ClientLogger logger = new ClientLogger(className);
        if (filePath != null && !(file = new File(filePath)).isAbsolute() && !(absolutePath = Paths.get(file.getAbsolutePath(), new String[0])).equals(normalizedPath = absolutePath.normalize())) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("%s is not valid. The path contains invalid characters `.` or `..`", pathName)));
        }
    }
}

