/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.AuthorizationCodeListener;
import com.azure.identity.implementation.HttpPipelineAdapter;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IntelliJAuthMethodDetails;
import com.azure.identity.implementation.IntelliJCacheAccessor;
import com.azure.identity.implementation.MSIToken;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.SynchronizedAccessor;
import com.azure.identity.implementation.VisualStudioCacheAccessor;
import com.azure.identity.implementation.util.CertificateUtil;
import com.azure.identity.implementation.util.ScopeUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.RefreshTokenParameters;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.aad.msal4jextensions.PersistenceSettings;
import com.microsoft.aad.msal4jextensions.PersistenceTokenCacheAccessAspect;
import com.microsoft.aad.msal4jextensions.persistence.linux.KeyRingAccessException;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class IdentityClient {
    private static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    private static final Random RANDOM = new Random();
    private static final String WINDOWS_STARTER = "cmd.exe";
    private static final String LINUX_MAC_STARTER = "/bin/sh";
    private static final String WINDOWS_SWITCHER = "/c";
    private static final String LINUX_MAC_SWITCHER = "-c";
    private static final String WINDOWS_PROCESS_ERROR_MESSAGE = "'az' is not recognized";
    private static final String LINUX_MAC_PROCESS_ERROR_MESSAGE = "(.*)az:(.*)not found";
    private static final String DEFAULT_WINDOWS_SYSTEM_ROOT = System.getenv("SystemRoot");
    private static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    private static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    private static final String DEFAULT_PUBLIC_CACHE_FILE_NAME = "msal.cache";
    private static final String DEFAULT_CONFIDENTIAL_CACHE_FILE_NAME = "msal.confidential.cache";
    private static final Path DEFAULT_CACHE_FILE_PATH = Platform.isWindows() ? Paths.get(System.getProperty("user.home"), "AppData", "Local", ".IdentityService") : Paths.get(System.getProperty("user.home"), ".IdentityService");
    private static final String DEFAULT_KEYCHAIN_SERVICE = "Microsoft.Developer.IdentityService";
    private static final String DEFAULT_PUBLIC_KEYCHAIN_ACCOUNT = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYCHAIN_ACCOUNT = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_NAME = "default";
    private static final String DEFAULT_KEYRING_SCHEMA = "msal.cache";
    private static final String DEFAULT_PUBLIC_KEYRING_ITEM_NAME = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYRING_ITEM_NAME = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_ATTR_NAME = "MsalClientID";
    private static final String DEFAULT_KEYRING_ATTR_VALUE = "Microsoft.Developer.IdentityService";
    private final ClientLogger logger = new ClientLogger(IdentityClient.class);
    private final IdentityClientOptions options;
    private final String tenantId;
    private final String clientId;
    private final String clientSecret;
    private final String certificatePath;
    private final String certificatePassword;
    private HttpPipelineAdapter httpPipelineAdapter;
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessor;
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor;

    IdentityClient(String tenantId, String clientId, String clientSecret, String certificatePath, String certificatePassword, boolean isSharedTokenCacheCredential, IdentityClientOptions options) {
        if (tenantId == null) {
            tenantId = "organizations";
        }
        if (options == null) {
            options = new IdentityClientOptions();
        }
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.certificatePath = certificatePath;
        this.certificatePassword = certificatePassword;
        this.options = options;
        this.publicClientApplicationAccessor = new SynchronizedAccessor<PublicClientApplication>(() -> this.getPublicClientApplication(isSharedTokenCacheCredential));
        this.confidentialClientApplicationAccessor = new SynchronizedAccessor<ConfidentialClientApplication>(() -> this.getConfidentialClientApplication());
    }

    private ConfidentialClientApplication getConfidentialClientApplication() {
        IClientSecret credential;
        if (this.clientId == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        if (this.clientSecret != null) {
            credential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        } else if (this.certificatePath != null) {
            try {
                if (this.certificatePassword == null) {
                    byte[] pemCertificateBytes = Files.readAllBytes(Paths.get(this.certificatePath, new String[0]));
                    credential = ClientCredentialFactory.createFromCertificate((PrivateKey)CertificateUtil.privateKeyFromPem(pemCertificateBytes), (X509Certificate)CertificateUtil.publicKeyFromPem(pemCertificateBytes));
                }
                credential = ClientCredentialFactory.createFromCertificate((InputStream)new FileInputStream(this.certificatePath), (String)this.certificatePassword);
            }
            catch (IOException | GeneralSecurityException e) {
                throw this.logger.logExceptionAsError(new RuntimeException("Failed to parse the certificate for the credential: " + e.getMessage(), e));
            }
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Must provide client secret or client certificate path"));
        }
        ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential);
        try {
            applicationBuilder = (ConfidentialClientApplication.Builder)applicationBuilder.authority(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            applicationBuilder.executorService(this.options.getExecutorService());
        }
        if (this.options.isSharedTokenCacheEnabled()) {
            try {
                PersistenceSettings.Builder persistenceSettingsBuilder = PersistenceSettings.builder((String)DEFAULT_CONFIDENTIAL_CACHE_FILE_NAME, (Path)DEFAULT_CACHE_FILE_PATH);
                if (Platform.isMac()) {
                    persistenceSettingsBuilder.setMacKeychain("Microsoft.Developer.IdentityService", "MSALConfidentialCache");
                }
                if (Platform.isLinux()) {
                    try {
                        persistenceSettingsBuilder.setLinuxKeyring(DEFAULT_KEYRING_NAME, "msal.cache", "MSALConfidentialCache", DEFAULT_KEYRING_ATTR_NAME, "Microsoft.Developer.IdentityService", null, null);
                        applicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)new PersistenceTokenCacheAccessAspect(persistenceSettingsBuilder.build()));
                    }
                    catch (KeyRingAccessException e) {
                        if (!this.options.getAllowUnencryptedCache()) {
                            throw this.logger.logExceptionAsError((RuntimeException)((Object)e));
                        }
                        persistenceSettingsBuilder.setLinuxUseUnprotectedFileAsCacheStorage(true);
                        applicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)new PersistenceTokenCacheAccessAspect(persistenceSettingsBuilder.build()));
                    }
                }
            }
            catch (Throwable t) {
                throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, t));
            }
        }
        return applicationBuilder.build();
    }

    private PublicClientApplication getPublicClientApplication(boolean sharedTokenCacheCredential) {
        if (this.clientId == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        PublicClientApplication.Builder publicClientApplicationBuilder = PublicClientApplication.builder((String)this.clientId);
        try {
            publicClientApplicationBuilder = (PublicClientApplication.Builder)publicClientApplicationBuilder.authority(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            publicClientApplicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            publicClientApplicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            publicClientApplicationBuilder.executorService(this.options.getExecutorService());
        }
        if (this.options.isSharedTokenCacheEnabled()) {
            try {
                PersistenceSettings.Builder persistenceSettingsBuilder = PersistenceSettings.builder((String)"msal.cache", (Path)DEFAULT_CACHE_FILE_PATH);
                if (Platform.isWindows()) {
                    publicClientApplicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)new PersistenceTokenCacheAccessAspect(persistenceSettingsBuilder.build()));
                } else if (Platform.isMac()) {
                    persistenceSettingsBuilder.setMacKeychain("Microsoft.Developer.IdentityService", "MSALCache");
                    publicClientApplicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)new PersistenceTokenCacheAccessAspect(persistenceSettingsBuilder.build()));
                } else if (Platform.isLinux()) {
                    try {
                        persistenceSettingsBuilder.setLinuxKeyring(DEFAULT_KEYRING_NAME, "msal.cache", "MSALCache", DEFAULT_KEYRING_ATTR_NAME, "Microsoft.Developer.IdentityService", null, null);
                        publicClientApplicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)new PersistenceTokenCacheAccessAspect(persistenceSettingsBuilder.build()));
                    }
                    catch (KeyRingAccessException e) {
                        if (!this.options.getAllowUnencryptedCache()) {
                            throw this.logger.logExceptionAsError((RuntimeException)((Object)e));
                        }
                        persistenceSettingsBuilder.setLinuxUseUnprotectedFileAsCacheStorage(true);
                        publicClientApplicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)new PersistenceTokenCacheAccessAspect(persistenceSettingsBuilder.build()));
                    }
                }
            }
            catch (Throwable t) {
                String message = "Shared token cache is unavailable in this environment.";
                if (sharedTokenCacheCredential) {
                    throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException(message, t)));
                }
                throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException(message, null, t));
            }
        }
        return publicClientApplicationBuilder.build();
    }

    public Mono<MsalToken> authenticateWithIntelliJ(TokenRequestContext request) {
        try {
            IntelliJCacheAccessor cacheAccessor = new IntelliJCacheAccessor(this.options.getIntelliJKeePassDatabasePath());
            IntelliJAuthMethodDetails authDetails = cacheAccessor.getAuthDetailsIfAvailable();
            String authType = authDetails.getAuthMethod();
            if (authType.equalsIgnoreCase("SP")) {
                Map<String, String> spDetails = cacheAccessor.getIntellijServicePrincipalDetails(authDetails.getCredFilePath());
                String authorityUrl = spDetails.get("authURL") + spDetails.get("tenant");
                try {
                    ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)spDetails.get("client"), (IClientCredential)ClientCredentialFactory.createFromSecret((String)spDetails.get("key"))).authority(authorityUrl);
                    if (this.httpPipelineAdapter != null) {
                        applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
                    } else if (this.options.getProxyOptions() != null) {
                        applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
                    }
                    if (this.options.getExecutorService() != null) {
                        applicationBuilder.executorService(this.options.getExecutorService());
                    }
                    ConfidentialClientApplication application = applicationBuilder.build();
                    return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet(request.getScopes())).build())).map(MsalToken::new);
                }
                catch (MalformedURLException e) {
                    return Mono.error((Throwable)e);
                }
            }
            if (authType.equalsIgnoreCase("DC")) {
                JsonNode intelliJCredentials = cacheAccessor.getDeviceCodeCredentials();
                String refreshToken = intelliJCredentials.get("refreshToken").textValue();
                RefreshTokenParameters parameters = RefreshTokenParameters.builder(new HashSet(request.getScopes()), (String)refreshToken).build();
                return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture((CompletableFuture)pc.acquireToken(parameters)).map(MsalToken::new));
            }
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("IntelliJ Authentication not available. Please login with Azure Tools for IntelliJ plugin in the IDE.")));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<AccessToken> authenticateWithAzureCli(TokenRequestContext request) {
        String azCommand = "az account get-access-token --output json --resource ";
        StringBuilder command = new StringBuilder();
        command.append(azCommand);
        String scopes = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scopes);
        }
        catch (IllegalArgumentException ex) {
            return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)ex));
        }
        command.append(scopes);
        AccessToken token = null;
        BufferedReader reader = null;
        try {
            String line;
            String switcher;
            String starter;
            if (this.isWindowsPlatform()) {
                starter = WINDOWS_STARTER;
                switcher = WINDOWS_SWITCHER;
            } else {
                starter = LINUX_MAC_STARTER;
                switcher = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder builder = new ProcessBuilder(starter, switcher, command.toString());
            String workingDirectory = this.getSafeWorkingDirectory();
            if (workingDirectory == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("A Safe Working directory could not be found to execute CLI command from."));
            }
            builder.directory(new File(workingDirectory));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(WINDOWS_PROCESS_ERROR_MESSAGE) || line.matches(LINUX_MAC_PROCESS_ERROR_MESSAGE)) {
                    throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("AzureCliCredential authentication unavailable. Azure CLI not installed")));
                }
                output.append(line);
            }
            String processOutput = output.toString();
            process.waitFor(10L, TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (processOutput.length() > 0) {
                    String redactedOutput = this.redactInfo("\"accessToken\": \"(.*?)(\"|$)", processOutput);
                    if (redactedOutput.contains("az login") || redactedOutput.contains("az account set")) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("AzureCliCredential authentication unavailable. Please run 'az login' to set up account")));
                    }
                    throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException(redactedOutput, null));
                }
                throw this.logger.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to invoke Azure CLI ", null));
            }
            Map objectMap = (Map)SERIALIZER_ADAPTER.deserialize(processOutput, Map.class, SerializerEncoding.JSON);
            String accessToken = (String)objectMap.get("accessToken");
            String time = (String)objectMap.get("expiresOn");
            String timeToSecond = time.substring(0, time.indexOf("."));
            String timeJoinedWithT = String.join((CharSequence)"T", timeToSecond.split(" "));
            OffsetDateTime expiresOn = LocalDateTime.parse(timeJoinedWithT, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
            token = new AccessToken(accessToken, expiresOn);
        }
        catch (IOException | InterruptedException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
        catch (RuntimeException e) {
            Mono mono = Mono.error((Throwable)this.logger.logExceptionAsError(e));
            return mono;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(ex)));
            }
        }
        return Mono.just((Object)token);
    }

    public Mono<AccessToken> authenticateWithConfidentialClient(TokenRequestContext request) {
        return this.confidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> confidentialClient.acquireToken(ClientCredentialParameters.builder(new HashSet(request.getScopes())).build())).map(MsalToken::new));
    }

    private HttpPipeline setupPipeline(HttpClient httpClient) {
        ArrayList<Object> policies = new ArrayList<Object>();
        HttpLogOptions httpLogOptions = new HttpLogOptions();
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(new RetryPolicy());
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().httpClient(httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(TokenRequestContext request, String username, String password) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(UserNamePasswordParameters.builder(new HashSet(request.getScopes()), (String)username, (char[])password.toCharArray()).build())).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with username and password", null, t)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithPublicClientCache(TokenRequestContext request, IAccount account) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet(request.getScopes()));
            if (account != null) {
                parametersBuilder = parametersBuilder.account(account);
            }
            try {
                return pc.acquireTokenSilently(parametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(this.logger.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(MsalToken::new).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))).switchIfEmpty(Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder forceParametersBuilder = SilentParameters.builder(new HashSet(request.getScopes())).forceRefresh(true);
            if (account != null) {
                forceParametersBuilder = forceParametersBuilder.account(account);
            }
            try {
                return pc.acquireTokenSilently(forceParametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(this.logger.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(MsalToken::new)));
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext request) {
        return this.confidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet(request.getScopes()));
            try {
                return confidentialClient.acquireTokenSilently(parametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(this.logger.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(ar -> new MsalToken((IAuthenticationResult)ar)).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))));
    }

    public Mono<MsalToken> authenticateWithDeviceCode(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> {
            DeviceCodeFlowParameters parameters = DeviceCodeFlowParameters.builder(new HashSet(request.getScopes()), dc -> deviceCodeConsumer.accept(new DeviceCodeInfo(dc.userCode(), dc.deviceCode(), dc.verificationUri(), OffsetDateTime.now().plusSeconds(dc.expiresIn()), dc.message()))).build();
            return pc.acquireToken(parameters);
        }).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with device code", null, t)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithVsCodeCredential(TokenRequestContext request, String cloud) {
        VisualStudioCacheAccessor accessor = new VisualStudioCacheAccessor();
        String credential = accessor.getCredentials("VS Code Azure", cloud);
        RefreshTokenParameters parameters = RefreshTokenParameters.builder(new HashSet(request.getScopes()), (String)credential).build();
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture((CompletableFuture)pc.acquireToken(parameters)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(TokenRequestContext request, String authorizationCode, URI redirectUrl) {
        AuthorizationCodeParameters parameters = AuthorizationCodeParameters.builder((String)authorizationCode, (URI)redirectUrl).scopes(new HashSet(request.getScopes())).build();
        Mono acquireToken = this.clientSecret != null ? this.confidentialClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parameters))) : this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parameters)));
        return acquireToken.onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with authorization code", null, t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(TokenRequestContext request, int port) {
        String authorityUrl = this.options.getAuthorityHost().replaceAll("/+$", "") + "/" + this.tenantId;
        return AuthorizationCodeListener.create(port).flatMap(server -> {
            String browserUri;
            URI redirectUri;
            try {
                redirectUri = new URI(String.format("http://localhost:%s", port));
                browserUri = String.format("%s/oauth2/v2.0/authorize?response_type=code&response_mode=query&prompt=select_account&client_id=%s&redirect_uri=%s&state=%s&scope=%s", authorityUrl, this.clientId, redirectUri.toString(), UUID.randomUUID(), String.join((CharSequence)" ", request.getScopes()));
            }
            catch (URISyntaxException e) {
                return server.dispose().then(Mono.error((Throwable)e));
            }
            return server.listen().mergeWith((Publisher)Mono.fromRunnable(() -> {
                try {
                    this.openUrl(browserUri);
                }
                catch (IOException e) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
                }
            }).subscribeOn(Schedulers.newSingle((String)"browser"))).next().flatMap(code -> this.authenticateWithAuthorizationCode(request, (String)code, redirectUri)).onErrorResume(t -> server.dispose().then(Mono.error((Throwable)t))).flatMap(msalToken -> server.dispose().then(Mono.just((Object)msalToken)));
        });
    }

    public Mono<MsalToken> authenticateWithSharedTokenCache(TokenRequestContext request, String username) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.getAccounts()).onErrorMap(t -> new CredentialUnavailableException("Cannot get accounts from token cache. Error: " + t.getMessage(), (Throwable)t)).flatMap(set -> {
            HashMap<String, IAccount> accounts = new HashMap<String, IAccount>();
            if (set.isEmpty()) {
                return Mono.error((Throwable)((Object)new CredentialUnavailableException("SharedTokenCacheCredential authentication unavailable. No accounts were found in the cache.")));
            }
            for (IAccount cached : set) {
                if (username != null && !username.equals(cached.username()) || accounts.containsKey(cached.homeAccountId())) continue;
                accounts.put(cached.homeAccountId(), cached);
            }
            if (accounts.isEmpty()) {
                return Mono.error((Throwable)new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. No account matching the specified username: %s was found in the cache.", username)));
            }
            if (accounts.size() > 1) {
                if (username == null) {
                    return Mono.error((Throwable)new RuntimeException("SharedTokenCacheCredential authentication unavailable. Multiple accounts were found in the cache. Use username and tenant id to disambiguate."));
                }
                return Mono.error((Throwable)new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. Multiple accounts matching the specified username: %s were found in the cache.", username)));
            }
            IAccount requestedAccount = (IAccount)accounts.values().iterator().next();
            return this.authenticateWithPublicClientCache(request, requestedAccount);
        }));
    }

    public Mono<AccessToken> authenticateToManagedIdentityEndpoint(String msiEndpoint, String msiSecret, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            String resource = ScopeUtil.scopesToResource(request.getScopes());
            HttpURLConnection connection = null;
            StringBuilder payload = new StringBuilder();
            payload.append("resource=");
            payload.append(URLEncoder.encode(resource, "UTF-8"));
            payload.append("&api-version=");
            payload.append(URLEncoder.encode("2017-09-01", "UTF-8"));
            if (this.clientId != null) {
                payload.append("&clientid=");
                payload.append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
            try {
                URL url = new URL(String.format("%s?%s", msiEndpoint, payload));
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (msiSecret != null) {
                    connection.setRequestProperty("Secret", msiSecret);
                }
                connection.setRequestProperty("Metadata", "true");
                connection.connect();
                Scanner s = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                String result = s.hasNext() ? s.next() : "";
                AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(result, MSIToken.class, SerializerEncoding.JSON);
                return accessToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToIMDSEndpoint(TokenRequestContext request) {
        String resource = ScopeUtil.scopesToResource(request.getScopes());
        StringBuilder payload = new StringBuilder();
        int imdsUpgradeTimeInMs = 70000;
        try {
            payload.append("api-version=");
            payload.append(URLEncoder.encode("2018-02-01", "UTF-8"));
            payload.append("&resource=");
            payload.append(URLEncoder.encode(resource, "UTF-8"));
            if (this.clientId != null) {
                payload.append("&client_id=");
                payload.append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        return this.checkIMDSAvailable().flatMap(available -> Mono.fromCallable(() -> {
            int retry = 1;
            while (retry <= this.options.getMaxRetry()) {
                URL url = null;
                HttpURLConnection connection = null;
                try {
                    url = new URL(String.format("http://169.254.169.254/metadata/identity/oauth2/token?%s", payload.toString()));
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Metadata", "true");
                    connection.connect();
                    Scanner s = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                    String result = s.hasNext() ? s.next() : "";
                    AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(result, MSIToken.class, SerializerEncoding.JSON);
                    return accessToken;
                }
                catch (IOException exception) {
                    int responseCode;
                    if (connection == null) {
                        throw this.logger.logExceptionAsError(new RuntimeException(String.format("Could not connect to the url: %s.", url), exception));
                    }
                    try {
                        responseCode = connection.getResponseCode();
                    }
                    catch (Exception e) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", e)));
                    }
                    if (responseCode == 410 || responseCode == 429 || responseCode == 404 || responseCode >= 500 && responseCode <= 599) {
                        int retryTimeoutInMs = this.options.getRetryTimeout().apply(Duration.ofSeconds(RANDOM.nextInt(retry))).getNano() / 1000;
                        int n = retryTimeoutInMs = responseCode == 410 && retryTimeoutInMs < 70000 ? 70000 : retryTimeoutInMs;
                        if (++retry > this.options.getMaxRetry()) break;
                        IdentityClient.sleep(retryTimeoutInMs);
                        continue;
                    }
                    throw this.logger.logExceptionAsError(new RuntimeException("Couldn't acquire access token from IMDS, verify your objectId, clientId or msiResourceId", exception));
                }
                finally {
                    if (connection == null) continue;
                    connection.disconnect();
                }
            }
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("MSI: Failed to acquire tokens after retrying %s times", this.options.getMaxRetry())));
        }));
    }

    private Mono<Boolean> checkIMDSAvailable() {
        StringBuilder payload = new StringBuilder();
        try {
            payload.append("api-version=");
            payload.append(URLEncoder.encode("2018-02-01", "UTF-8"));
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            URL url = new URL(String.format("http://169.254.169.254/metadata/identity/oauth2/token?%s", payload.toString()));
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(500);
                connection.connect();
            }
            catch (Exception e) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", e)));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return true;
        });
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }

    private String getSafeWorkingDirectory() {
        if (this.isWindowsPlatform()) {
            if (CoreUtils.isNullOrEmpty((CharSequence)DEFAULT_WINDOWS_SYSTEM_ROOT)) {
                return null;
            }
            return DEFAULT_WINDOWS_SYSTEM_ROOT + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }

    private boolean isWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    private String redactInfo(String regex, String input) {
        return input.replaceAll(regex, "****");
    }

    void openUrl(String url) throws IOException {
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (os.contains("mac")) {
            rt.exec("open " + url);
        } else if (os.contains("nix") || os.contains("nux")) {
            rt.exec("xdg-open " + url);
        } else {
            this.logger.error("Browser could not be opened - please open {} in a browser on this device.", new Object[]{url});
        }
    }

    private CompletableFuture<IAuthenticationResult> getFailedCompletableFuture(Exception e) {
        CompletableFuture<IAuthenticationResult> completableFuture = new CompletableFuture<IAuthenticationResult>();
        completableFuture.completeExceptionally(e);
        return completableFuture;
    }

    private void initializeHttpPipelineAdapter() {
        HttpPipeline httpPipeline = this.options.getHttpPipeline();
        if (httpPipeline != null) {
            this.httpPipelineAdapter = new HttpPipelineAdapter(httpPipeline);
        } else {
            HttpClient httpClient = this.options.getHttpClient();
            if (httpClient != null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(httpClient));
            } else if (this.options.getProxyOptions() == null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(HttpClient.createDefault()));
            }
        }
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }
}

