/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AppServiceMsiCredential {
    private final String msiEndpoint;
    private final String msiSecret;
    private final IdentityClient identityClient;
    private final String clientId;
    private final ClientLogger logger = new ClientLogger(AppServiceMsiCredential.class);

    AppServiceMsiCredential(String clientId, IdentityClient identityClient) {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.msiEndpoint = configuration.get("MSI_ENDPOINT");
        this.msiSecret = configuration.get("MSI_SECRET");
        this.identityClient = identityClient;
        this.clientId = clientId;
        if (!this.msiEndpoint.startsWith("https") && !this.msiEndpoint.startsWith("http")) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("MSI Endpoint should start with 'https' or 'http' scheme."));
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        return this.identityClient.authenticateToManagedIdentityEndpoint(this.msiEndpoint, this.msiSecret, request);
    }
}

