/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.concurrent.ExecutorService;

public abstract class AadCredentialBuilderBase<T extends AadCredentialBuilderBase<T>>
extends CredentialBuilderBase<T> {
    String clientId;
    String tenantId;

    public T authorityHost(String authorityHost) {
        ValidationUtil.validateAuthHost(this.getClass().getSimpleName(), authorityHost);
        this.identityClientOptions.setAuthorityHost(authorityHost);
        return (T)this;
    }

    public T clientId(String clientId) {
        ValidationUtil.validateClientIdCharacterRange(this.getClass().getSimpleName(), clientId);
        this.clientId = clientId;
        return (T)this;
    }

    public T tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(this.getClass().getSimpleName(), tenantId);
        this.tenantId = tenantId;
        return (T)this;
    }

    public T executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return (T)this;
    }
}

