/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.sas;

import java.util.Locale;

public final class TableAccountSasService {
    private boolean blob;
    private boolean file;
    private boolean queue;
    private boolean table;

    public static TableAccountSasService parse(String servicesString) {
        TableAccountSasService services = new TableAccountSasService();
        block6: for (int i = 0; i < servicesString.length(); ++i) {
            char c = servicesString.charAt(i);
            switch (c) {
                case 'b': {
                    services.blob = true;
                    continue block6;
                }
                case 'f': {
                    services.file = true;
                    continue block6;
                }
                case 'q': {
                    services.queue = true;
                    continue block6;
                }
                case 't': {
                    services.table = true;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Services", servicesString, Character.valueOf(c)));
                }
            }
        }
        return services;
    }

    public boolean hasBlobAccess() {
        return this.blob;
    }

    public TableAccountSasService setBlobAccess(boolean blob) {
        this.blob = blob;
        return this;
    }

    public boolean hasFileAccess() {
        return this.file;
    }

    public TableAccountSasService setFileAccess(boolean file) {
        this.file = file;
        return this;
    }

    public boolean hasQueueAccess() {
        return this.queue;
    }

    public TableAccountSasService setQueueAccess(boolean queue) {
        this.queue = queue;
        return this;
    }

    public boolean hasTableAccess() {
        return this.table;
    }

    public TableAccountSasService setTableAccess(boolean table) {
        this.table = table;
        return this;
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        if (this.blob) {
            value.append('b');
        }
        if (this.queue) {
            value.append('q');
        }
        if (this.table) {
            value.append('t');
        }
        if (this.file) {
            value.append('f');
        }
        return value.toString();
    }
}

