/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class ConfigurationSettingJsonSerializer
extends JsonSerializer<ConfigurationSetting> {
    static final String ID = "id";
    static final String DESCRIPTION = "description";
    static final String DISPLAY_NAME = "display_name";
    static final String ENABLED = "enabled";
    static final String CONDITIONS = "conditions";
    static final String CLIENT_FILTERS = "client_filters";
    static final String NAME = "name";
    static final String PARAMETERS = "parameters";
    static final String KEY = "key";
    static final String LABEL = "label";
    static final String VALUE = "value";
    static final String CONTENT_TYPE = "content_type";
    static final String ETAG = "etag";
    static final String LAST_MODIFIED = "last_modified";
    static final String LOCKED = "locked";
    static final String TAGS = "tags";
    static final String URI = "uri";
    static final SimpleModule MODULE = new SimpleModule();

    public static SimpleModule getModule() {
        return MODULE;
    }

    public void serialize(ConfigurationSetting value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ConfigurationSettingJsonSerializer.write(value, gen);
    }

    private static void write(ConfigurationSetting value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        String settingValue = value instanceof FeatureFlagConfigurationSetting ? ConfigurationSettingJsonSerializer.writeFeatureFlagConfigurationSetting((FeatureFlagConfigurationSetting)value) : (value instanceof SecretReferenceConfigurationSetting ? ConfigurationSettingJsonSerializer.writeSecretReferenceConfigurationSetting((SecretReferenceConfigurationSetting)value) : value.getValue());
        gen.writeStringField(VALUE, settingValue);
        gen.writeStringField(KEY, value.getKey());
        if (!CoreUtils.isNullOrEmpty((CharSequence)value.getLabel())) {
            gen.writeStringField(LABEL, value.getLabel());
        }
        gen.writeStringField(CONTENT_TYPE, value.getContentType());
        gen.writeStringField(ETAG, value.getETag());
        gen.writeBooleanField(LOCKED, value.isReadOnly());
        gen.writeObjectFieldStart(TAGS);
        ConfigurationSettingJsonSerializer.writeMapProperties(value.getTags(), gen);
        gen.writeEndObject();
        if (value.getLastModified() != null) {
            gen.writeStringField(LAST_MODIFIED, value.getLastModified().format(DateTimeFormatter.ISO_DATE_TIME));
        }
        gen.writeEndObject();
    }

    public static String writeSecretReferenceConfigurationSetting(SecretReferenceConfigurationSetting setting) throws IOException {
        StringWriter jsonObjectWriter = new StringWriter();
        JsonGenerator gen = new JsonFactory().createGenerator((Writer)jsonObjectWriter);
        gen.writeStartObject();
        gen.writeStringField(URI, setting.getSecretId());
        gen.writeEndObject();
        gen.close();
        return jsonObjectWriter.toString();
    }

    public static String writeFeatureFlagConfigurationSetting(FeatureFlagConfigurationSetting setting) throws IOException {
        StringWriter jsonObjectWriter = new StringWriter();
        JsonGenerator gen = new JsonFactory().createGenerator((Writer)jsonObjectWriter);
        gen.writeStartObject();
        gen.writeStringField(ID, setting.getFeatureId());
        gen.writeStringField(DESCRIPTION, setting.getDescription());
        gen.writeStringField(DISPLAY_NAME, setting.getDisplayName());
        gen.writeBooleanField(ENABLED, setting.isEnabled());
        gen.writeObjectFieldStart(CONDITIONS);
        gen.writeArrayFieldStart(CLIENT_FILTERS);
        for (FeatureFlagFilter filter : setting.getClientFilters()) {
            gen.writeStartObject();
            gen.writeStringField(NAME, filter.getName());
            gen.writeObjectFieldStart(PARAMETERS);
            ConfigurationSettingJsonSerializer.writeMapProperties(filter.getParameters(), gen);
            gen.writeEndObject();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.writeEndObject();
        gen.close();
        return jsonObjectWriter.toString();
    }

    private static void writeMapProperties(Map<String, ? extends Object> properties, JsonGenerator gen) throws IOException {
        if (CoreUtils.isNullOrEmpty(properties)) {
            return;
        }
        for (Map.Entry<String, ? extends Object> property : properties.entrySet()) {
            gen.writeFieldName(property.getKey());
            gen.writeObject((Object)property.getValue().toString());
        }
    }

    static {
        MODULE.addSerializer(ConfigurationSetting.class, (JsonSerializer)new ConfigurationSettingJsonSerializer());
    }
}

