/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingHelper;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ConfigurationSettingJsonDeserializer
extends JsonDeserializer<ConfigurationSetting> {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationSettingJsonDeserializer.class);
    private static final String FEATURE_FLAG_CONTENT_TYPE = "application/vnd.microsoft.appconfig.ff+json;charset=utf-8";
    private static final String SECRET_REFERENCE_CONTENT_TYPE = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";
    private static final JacksonAdapter MAPPER = (JacksonAdapter)JacksonAdapter.createDefaultSerializerAdapter();
    private static final SimpleModule MODULE = new SimpleModule().addDeserializer(ConfigurationSetting.class, (JsonDeserializer)new ConfigurationSettingJsonDeserializer()).addDeserializer(SecretReferenceConfigurationSetting.class, ConfigurationSettingJsonDeserializer.configurationSettingSubclassDeserializer(SecretReferenceConfigurationSetting.class)).addDeserializer(FeatureFlagConfigurationSetting.class, ConfigurationSettingJsonDeserializer.configurationSettingSubclassDeserializer(FeatureFlagConfigurationSetting.class));

    public static SimpleModule getModule() {
        return MODULE;
    }

    public ConfigurationSetting deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return ConfigurationSettingJsonDeserializer.read(ctxt.readTree(p));
    }

    private static ConfigurationSetting read(JsonNode node) {
        String key = null;
        JsonNode keyNode = node.get("key");
        if (keyNode != null && !keyNode.isNull()) {
            key = keyNode.asText();
        }
        JsonNode contentTypeNode = node.get("content_type");
        String contentType = null;
        if (contentTypeNode != null && !contentTypeNode.isNull()) {
            contentType = contentTypeNode.asText();
        }
        ConfigurationSetting baseSetting = ConfigurationSettingJsonDeserializer.readConfigurationSetting(node);
        try {
            if (key != null && key.startsWith(".appconfig.featureflag/") && FEATURE_FLAG_CONTENT_TYPE.equals(contentType)) {
                return ConfigurationSettingJsonDeserializer.readFeatureFlagConfigurationSetting(node, baseSetting);
            }
            if (SECRET_REFERENCE_CONTENT_TYPE.equals(contentType)) {
                return ConfigurationSettingJsonDeserializer.readSecretReferenceConfigurationSetting(node, baseSetting);
            }
        }
        catch (Exception exception) {
            LOGGER.info("The setting is neither a 'FeatureFlagConfigurationSetting' nor 'SecretReferenceConfigurationSetting', return the setting as 'ConfigurationSetting'. Error: ", new Object[]{exception});
        }
        return baseSetting;
    }

    private static SecretReferenceConfigurationSetting readSecretReferenceConfigurationSetting(JsonNode settingNode, ConfigurationSetting baseSetting) {
        JsonNode valueNode = settingNode.get("value");
        String settingValue = null;
        if (valueNode != null && !valueNode.isNull()) {
            settingValue = valueNode.asText();
        }
        ConfigurationSetting secretReferenceConfigurationSetting = ConfigurationSettingJsonDeserializer.readSecretReferenceConfigurationSettingValue(baseSetting.getKey(), settingValue).setValue(settingValue).setLabel(baseSetting.getLabel()).setETag(baseSetting.getETag()).setContentType(baseSetting.getContentType()).setTags((Map)baseSetting.getTags());
        ConfigurationSettingJsonDeserializer.configurationSettingSubclassReflection(secretReferenceConfigurationSetting, settingNode);
        return secretReferenceConfigurationSetting;
    }

    private static ConfigurationSetting readConfigurationSetting(JsonNode setting) {
        try {
            return (ConfigurationSetting)MAPPER.serializer().treeToValue((TreeNode)setting, ConfigurationSetting.class);
        }
        catch (JsonProcessingException exception) {
            throw LOGGER.logExceptionAsError(new RuntimeException(exception));
        }
    }

    private static FeatureFlagConfigurationSetting readFeatureFlagConfigurationSetting(JsonNode settingNode, ConfigurationSetting baseSetting) {
        JsonNode valueNode = settingNode.get("value");
        String settingValue = null;
        if (valueNode != null && !valueNode.isNull()) {
            settingValue = valueNode.asText();
        }
        ConfigurationSetting featureFlagConfigurationSetting = ConfigurationSettingJsonDeserializer.readFeatureFlagConfigurationSettingValue(settingValue).setKey(baseSetting.getKey()).setValue(settingValue).setLabel(baseSetting.getLabel()).setETag(baseSetting.getETag()).setContentType(baseSetting.getContentType()).setTags((Map)baseSetting.getTags());
        ConfigurationSettingJsonDeserializer.configurationSettingSubclassReflection(featureFlagConfigurationSetting, settingNode);
        return featureFlagConfigurationSetting;
    }

    private static <T extends ConfigurationSetting> ConfigurationSetting configurationSettingSubclassReflection(ConfigurationSetting setting, JsonNode settingNode) {
        JsonNode isLockedNode = settingNode.get("locked");
        boolean locked = false;
        if (isLockedNode != null && !isLockedNode.isNull()) {
            locked = isLockedNode.asBoolean();
        }
        ConfigurationSettingHelper.setReadOnly(setting, locked);
        JsonNode lastModifiedNode = settingNode.get("last_modified");
        if (lastModifiedNode != null && !lastModifiedNode.isNull()) {
            String lastModifiedText = lastModifiedNode.asText();
            OffsetDateTime lastModified = OffsetDateTime.parse(lastModifiedText, DateTimeFormatter.ISO_DATE_TIME);
            ConfigurationSettingHelper.setLastModified(setting, lastModified);
        }
        return setting;
    }

    public static SecretReferenceConfigurationSetting readSecretReferenceConfigurationSettingValue(String key, String settingValue) {
        JsonNode settingValueNode = ConfigurationSettingJsonDeserializer.toJsonNode(settingValue);
        JsonNode uriNode = settingValueNode.get("uri");
        String secretID = null;
        if (uriNode != null && !uriNode.isNull()) {
            secretID = uriNode.asText();
        }
        return new SecretReferenceConfigurationSetting(key, secretID);
    }

    public static FeatureFlagConfigurationSetting readFeatureFlagConfigurationSettingValue(String settingValue) {
        JsonNode valueNode = ConfigurationSettingJsonDeserializer.toJsonNode(settingValue);
        JsonNode featureIdNode = valueNode.get("id");
        String featureId = null;
        if (featureIdNode != null && !featureIdNode.isNull()) {
            featureId = featureIdNode.asText();
        }
        JsonNode descriptionNode = valueNode.get("description");
        String description = null;
        if (descriptionNode != null && !descriptionNode.isNull()) {
            description = descriptionNode.asText();
        }
        JsonNode displayNameNode = valueNode.get("display_name");
        String displayName = null;
        if (displayNameNode != null && !displayNameNode.isNull()) {
            displayName = displayNameNode.asText();
        }
        JsonNode isEnabledNode = valueNode.get("enabled");
        boolean isEnabled = false;
        if (isEnabledNode != null && !isEnabledNode.isNull()) {
            isEnabled = isEnabledNode.asBoolean();
        }
        JsonNode conditionsNode = valueNode.get("conditions");
        List<FeatureFlagFilter> filters = null;
        if (conditionsNode != null && !conditionsNode.isNull()) {
            filters = ConfigurationSettingJsonDeserializer.readConditions(conditionsNode);
        }
        return new FeatureFlagConfigurationSetting(featureId, isEnabled).setDescription(description).setDisplayName(displayName).setClientFilters(filters);
    }

    private static List<FeatureFlagFilter> readConditions(JsonNode conditionsNode) {
        JsonNode clientFiltersNode = conditionsNode.get("client_filters");
        if (clientFiltersNode == null || clientFiltersNode.isNull()) {
            return Collections.emptyList();
        }
        return ConfigurationSettingJsonDeserializer.readFeatureFlagFilters(clientFiltersNode);
    }

    private static List<FeatureFlagFilter> readFeatureFlagFilters(JsonNode featureFlagFilters) {
        ArrayList<FeatureFlagFilter> filters = new ArrayList<FeatureFlagFilter>();
        featureFlagFilters.forEach(filter -> filters.add(ConfigurationSettingJsonDeserializer.readFeatureFlagFilter(filter)));
        return filters;
    }

    private static FeatureFlagFilter readFeatureFlagFilter(JsonNode filter) {
        String name = null;
        JsonNode filterNameNode = filter.get("name");
        if (filterNameNode != null && !filterNameNode.isNull()) {
            name = filterNameNode.asText();
        }
        FeatureFlagFilter flagFilter = new FeatureFlagFilter(name);
        JsonNode parametersNode = filter.get("parameters");
        if (parametersNode != null && !parametersNode.isNull()) {
            flagFilter.setParameters(ConfigurationSettingJsonDeserializer.readParameters(parametersNode));
        }
        return flagFilter;
    }

    private static Map<String, Object> readParameters(JsonNode node) {
        HashMap<String, Object> additionalProperties = null;
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            String propertyName = (String)field.getKey();
            if (additionalProperties == null) {
                additionalProperties = new HashMap<String, Object>();
            }
            additionalProperties.put(propertyName, ConfigurationSettingJsonDeserializer.readAdditionalPropertyValue((JsonNode)field.getValue()));
        }
        return additionalProperties;
    }

    private static Object readAdditionalPropertyValue(JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return node.asText();
            }
            case NUMBER: {
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                if (node.isFloat()) {
                    return Float.valueOf(node.floatValue());
                }
                return node.asDouble();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NULL: 
            case MISSING: {
                return null;
            }
            case OBJECT: {
                HashMap object = new HashMap();
                node.fields().forEachRemaining(field -> object.put((String)field.getKey(), ConfigurationSettingJsonDeserializer.readAdditionalPropertyValue((JsonNode)field.getValue())));
                return object;
            }
            case ARRAY: {
                ArrayList array = new ArrayList();
                node.forEach(element -> array.add(ConfigurationSettingJsonDeserializer.readAdditionalPropertyValue(element)));
                return array;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Unsupported additional property type %s.", node.getNodeType())));
    }

    private static <T extends ConfigurationSetting> JsonDeserializer<T> configurationSettingSubclassDeserializer(final Class<T> subclass) {
        return new JsonDeserializer<T>(){

            public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return (ConfigurationSetting)subclass.cast(ConfigurationSettingJsonDeserializer.read(ctxt.readTree(p)));
            }
        };
    }

    private static JsonNode toJsonNode(String settingValue) {
        try {
            return MAPPER.serializer().readTree(settingValue);
        }
        catch (JsonProcessingException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }
}

