/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FluxByteBufferContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(FluxByteBufferContent.class);
    private final Flux<ByteBuffer> content;
    private final AtomicReference<FluxByteBufferContent> cachedReplayableContent = new AtomicReference();
    private final Long length;
    private final boolean isReplayable;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<FluxByteBufferContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FluxByteBufferContent.class, byte[].class, "bytes");

    public FluxByteBufferContent(Flux<ByteBuffer> content) {
        this(content, null);
    }

    public FluxByteBufferContent(Flux<ByteBuffer> content, Long length) {
        this(content, length, false);
    }

    public FluxByteBufferContent(Flux<ByteBuffer> content, Long length, boolean isReplayable) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
        this.length = length;
        this.isReplayable = isReplayable;
    }

    @Override
    public Long getLength() {
        byte[] data = BYTES_UPDATER.get(this);
        if (data != null) {
            return data.length;
        }
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.toBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content;
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        if (this.isReplayable) {
            return this;
        }
        FluxByteBufferContent replayableContent = this.cachedReplayableContent.get();
        if (replayableContent != null) {
            return replayableContent;
        }
        Flux bufferedFlux = this.content.map(buffer -> {
            ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
            copy.put((ByteBuffer)buffer);
            copy.flip();
            return copy;
        }).collect(LinkedList::new, LinkedList::add).cache().flatMapMany(listOfBuffers -> Flux.fromIterable((Iterable)listOfBuffers).map(ByteBuffer::duplicate));
        replayableContent = new FluxByteBufferContent((Flux<ByteBuffer>)bufferedFlux, this.length, true);
        this.cachedReplayableContent.set(replayableContent);
        return replayableContent;
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        return Mono.fromCallable(this::toReplayableContent);
    }

    private byte[] getBytes() {
        if (this.length != null && this.length > 0x7FFFFFF7L) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.length));
        }
        return (byte[])FluxUtil.collectBytesInByteBufferStream(this.content).share().block();
    }
}

