/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.netty.buffer.ByteBuf;
import io.netty.util.Version;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.netty.Connection;
import reactor.netty.channel.ChannelOperations;

public final class Utility {
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    private static final String PROPERTIES_FILE_NAME = "azure-core-http-netty.properties";
    private static final String NETTY_VERSION_PROPERTY = "netty-version";
    private static final String NETTY_TCNATIVE_VERSION_PROPERTY = "netty-tcnative-version";
    private static final List<String> REQUIRED_NETTY_VERSION_ARTIFACTS = Arrays.asList("netty-common", "netty-handler", "netty-handler-proxy", "netty-buffer", "netty-codec", "netty-codec-http", "netty-codec-http2");
    private static final List<String> OPTIONAL_NETTY_VERSION_ARTIFACTS = Arrays.asList("netty-transport-native-unix-common", "netty-transport-native-epoll", "netty-transport-native-kqueue");
    private static final List<String> NETTY_TCNATIVE_VERSION_ARTIFACTS = Collections.singletonList("netty-tcnative-boringssl-static");

    public static ByteBuffer deepCopyBuffer(ByteBuf byteBuf) {
        ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
        byteBuf.readBytes(buffer);
        buffer.rewind();
        return buffer;
    }

    public static void closeConnection(Connection reactorNettyConnection) {
        if (reactorNettyConnection instanceof ChannelOperations) {
            ChannelOperations channelOperations = (ChannelOperations)reactorNettyConnection;
            if (!channelOperations.isInboundDisposed()) {
                channelOperations.channel().eventLoop().execute(() -> ((ChannelOperations)channelOperations).discard());
            }
        } else if (!reactorNettyConnection.isDisposed()) {
            reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)reactorNettyConnection).dispose());
        }
    }

    public static void validateNettyVersions() {
        Version version;
        Map pomVersions = CoreUtils.getProperties((String)PROPERTIES_FILE_NAME);
        String nettyVersion = (String)pomVersions.get(NETTY_VERSION_PROPERTY);
        String nettyTcnativeVersion = (String)pomVersions.get(NETTY_TCNATIVE_VERSION_PROPERTY);
        Map nettyVersions = Version.identify();
        ArrayList<String> versionMismatches = new ArrayList<String>(11);
        for (String artifact : REQUIRED_NETTY_VERSION_ARTIFACTS) {
            version = (Version)nettyVersions.get(artifact);
            if (version == null) {
                versionMismatches.add("'io.netty:" + artifact + "' version not found (expected: " + nettyVersion + ")");
                continue;
            }
            if (Objects.equals(version.artifactVersion(), nettyVersion)) continue;
            versionMismatches.add("'io.netty:" + artifact + "' version: " + version.artifactVersion() + " (expected: " + nettyVersion + ")");
        }
        for (String artifact : OPTIONAL_NETTY_VERSION_ARTIFACTS) {
            version = (Version)nettyVersions.get(artifact);
            if (version == null || Objects.equals(version.artifactVersion(), nettyVersion)) continue;
            versionMismatches.add("'io.netty:" + artifact + "' version: " + version.artifactVersion() + " (expected: " + nettyVersion + ")");
        }
        for (String artifact : NETTY_TCNATIVE_VERSION_ARTIFACTS) {
            version = (Version)nettyVersions.get(artifact);
            if (version == null || Objects.equals(version.artifactVersion(), nettyTcnativeVersion)) continue;
            versionMismatches.add("'io.netty:" + artifact + "' version: " + version.artifactVersion() + " (expected: " + nettyTcnativeVersion + ")");
        }
        if (!versionMismatches.isEmpty()) {
            LOGGER.warning("The following Netty dependencies have versions that do not match the versions specified in the azure-core-http-netty pom.xml file. This may result in unexpected behavior. If your application runs without issue this message can be ignored, otherwise please update the Netty dependencies to match the versions specified in the pom.xml file. Versions found in runtime: " + CoreUtils.stringJoin((String)",", versionMismatches));
        }
    }

    private Utility() {
    }
}

