/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.AzureNettyHttpClientContext;
import com.azure.core.http.netty.implementation.NettyAsyncHttpBufferedResponse;
import com.azure.core.http.netty.implementation.NettyAsyncHttpResponse;
import com.azure.core.http.netty.implementation.Utility;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.retry.Retry;

class NettyAsyncHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(NettyAsyncHttpClient.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String AZURE_EAGERLY_READ_RESPONSE = "azure-eagerly-read-response";
    private static final String AZURE_IGNORE_RESPONSE_BODY = "azure-ignore-response-body";
    private static final String AZURE_RESPONSE_TIMEOUT = "azure-response-timeout";
    private static final String AZURE_EAGERLY_CONVERT_HEADERS = "azure-eagerly-convert-headers";
    final boolean disableBufferCopy;
    final boolean addProxyHandler;
    final reactor.netty.http.client.HttpClient nettyClient;

    NettyAsyncHttpClient(reactor.netty.http.client.HttpClient nettyClient, boolean disableBufferCopy, boolean addProxyHandler) {
        this.nettyClient = nettyClient;
        this.disableBufferCopy = disableBufferCopy;
        this.addProxyHandler = addProxyHandler;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        boolean eagerlyReadResponse = context.getData((Object)AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = context.getData((Object)AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        boolean headersEagerlyConverted = context.getData((Object)AZURE_EAGERLY_CONVERT_HEADERS).orElse(false);
        Long responseTimeout = context.getData((Object)AZURE_RESPONSE_TIMEOUT).filter(timeoutDuration -> timeoutDuration instanceof Duration).map(timeoutDuration -> ((Duration)timeoutDuration).toMillis()).orElse(null);
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        Flux nettyRequest = ((HttpClient.RequestSender)this.nettyClient.request(NettyAsyncHttpClient.toReactorNettyHttpMethod(request.getHttpMethod())).uri(request.getUrl().toString())).send(NettyAsyncHttpClient.bodySendDelegate(request)).responseConnection(NettyAsyncHttpClient.responseDelegate(request, this.disableBufferCopy, eagerlyReadResponse, ignoreResponseBody, headersEagerlyConverted));
        if (responseTimeout != null || progressReporter != null) {
            nettyRequest = nettyRequest.contextWrite(ctx -> ctx.put((Object)"azure-sdk-pipeline-data", (Object)new AzureNettyHttpClientContext(responseTimeout, progressReporter)));
        }
        return nettyRequest.single().flatMap(response -> {
            if (this.addProxyHandler && response.getStatusCode() == 407) {
                return Mono.error((Throwable)new ProxyConnectException("First attempt to connect to proxy failed."));
            }
            return Mono.just((Object)response);
        }).onErrorMap(throwable -> {
            if (throwable instanceof SSLException && throwable.getCause() instanceof ProxyConnectException) {
                return throwable.getCause();
            }
            return throwable;
        }).retryWhen((Retry)Retry.max((long)1L).filter(throwable -> throwable instanceof ProxyConnectException).onRetryExhaustedThrow((ignoredSpec, signal) -> signal.failure()));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        try {
            return (HttpResponse)this.send(request, context).block();
        }
        catch (Exception e) {
            Throwable unwrapped = Exceptions.unwrap((Throwable)e);
            if (unwrapped instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)unwrapped);
            }
            if (unwrapped instanceof IOException) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException((IOException)unwrapped));
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(unwrapped));
        }
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader hdr : restRequest.getHeaders()) {
                reactorNettyRequest.requestHeaders().set(hdr.getName(), (Iterable)hdr.getValuesList());
            }
            BinaryData body = restRequest.getBodyAsBinaryData();
            if (body != null) {
                BinaryDataContent bodyContent = BinaryDataHelper.getContent((BinaryData)body);
                if (bodyContent instanceof ByteArrayContent) {
                    return reactorNettyOutbound.send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])bodyContent.toBytes())));
                }
                if (bodyContent instanceof StringContent || bodyContent instanceof SerializableContent) {
                    return reactorNettyOutbound.send((Publisher)Mono.fromSupplier(() -> Unpooled.wrappedBuffer((byte[])bodyContent.toBytes())));
                }
                if (bodyContent instanceof FileContent) {
                    return NettyAsyncHttpClient.sendFile(restRequest, reactorNettyOutbound, (FileContent)bodyContent);
                }
                if (bodyContent instanceof InputStreamContent) {
                    return NettyAsyncHttpClient.sendInputStream(reactorNettyOutbound, (InputStreamContent)bodyContent);
                }
                Flux nettyByteBufFlux = restRequest.getBody().map(Unpooled::wrappedBuffer);
                return reactorNettyOutbound.send((Publisher)nettyByteBufFlux);
            }
            return reactorNettyOutbound;
        };
    }

    private static NettyOutbound sendFile(HttpRequest restRequest, NettyOutbound reactorNettyOutbound, FileContent fileContent) {
        if (fileContent.getLength() == 0L) {
            return reactorNettyOutbound.sendByteArray((Publisher)Flux.just((Object)EMPTY_BYTES));
        }
        if (restRequest.getUrl().getProtocol().equals("https")) {
            return reactorNettyOutbound.sendUsing(() -> FileChannel.open(fileContent.getFile(), StandardOpenOption.READ), (c, fc) -> {
                if (c.channel().pipeline().get(ChunkedWriteHandler.class) == null) {
                    c.addHandlerLast("reactor.left.chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                }
                try {
                    return new ChunkedNioFile(fc, fileContent.getPosition(), fileContent.getLength().longValue(), fileContent.getChunkSize());
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
                }
            }, fc -> {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
                }
            });
        }
        return reactorNettyOutbound.sendFile(fileContent.getFile(), fileContent.getPosition(), fileContent.getLength().longValue());
    }

    private static NettyOutbound sendInputStream(NettyOutbound reactorNettyOutbound, InputStreamContent bodyContent) {
        return reactorNettyOutbound.sendUsing(() -> ((InputStreamContent)bodyContent).toStream(), (c, stream) -> {
            if (c.channel().pipeline().get(ChunkedWriteHandler.class) == null) {
                c.addHandlerLast("reactor.left.chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            }
            return new ChunkedStream(stream);
        }, stream -> {});
    }

    private static BiFunction<HttpClientResponse, Connection, Mono<HttpResponse>> responseDelegate(HttpRequest restRequest, boolean disableBufferCopy, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean headersEagerlyConverted) {
        return (reactorNettyResponse, reactorNettyConnection) -> {
            if (eagerlyReadResponse || ignoreResponseBody) {
                return reactorNettyConnection.inbound().receive().aggregate().asByteArray().doFinally(ignored -> Utility.closeConnection(reactorNettyConnection)).switchIfEmpty(Mono.just((Object)EMPTY_BYTES)).map(bytes -> new NettyAsyncHttpBufferedResponse((HttpClientResponse)reactorNettyResponse, restRequest, (byte[])bytes, headersEagerlyConverted));
            }
            return Mono.just((Object)((Object)new NettyAsyncHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection, restRequest, disableBufferCopy, headersEagerlyConverted)));
        };
    }

    private static io.netty.handler.codec.http.HttpMethod toReactorNettyHttpMethod(HttpMethod azureHttpMethod) {
        switch (azureHttpMethod) {
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unknown HttpMethod '" + azureHttpMethod + "'."));
    }
}

