/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.ClockImpl;
import com.auth0.jwt.JWTDecoder;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.InvalidClaimException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.Clock;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JWTVerifier
implements com.auth0.jwt.interfaces.JWTVerifier {
    private final Algorithm algorithm;
    final Map<String, Object> claims;
    private final Clock clock;
    private final JWTParser parser;

    JWTVerifier(Algorithm algorithm, Map<String, Object> claims, Clock clock) {
        this.algorithm = algorithm;
        this.claims = Collections.unmodifiableMap(claims);
        this.clock = clock;
        this.parser = new JWTParser();
    }

    static Verification init(Algorithm algorithm) throws IllegalArgumentException {
        return new BaseVerification(algorithm);
    }

    @Override
    public DecodedJWT verify(String token) throws JWTVerificationException {
        JWTDecoder jwt = new JWTDecoder(this.parser, token);
        return this.verify(jwt);
    }

    @Override
    public DecodedJWT verify(DecodedJWT jwt) throws JWTVerificationException {
        this.verifyAlgorithm(jwt, this.algorithm);
        this.algorithm.verify(jwt);
        this.verifyClaims(jwt, this.claims);
        return jwt;
    }

    private void verifyAlgorithm(DecodedJWT jwt, Algorithm expectedAlgorithm) throws AlgorithmMismatchException {
        if (!expectedAlgorithm.getName().equals(jwt.getAlgorithm())) {
            throw new AlgorithmMismatchException("The provided Algorithm doesn't match the one defined in the JWT's Header.");
        }
    }

    private void verifyClaims(DecodedJWT jwt, Map<String, Object> claims) throws TokenExpiredException, InvalidClaimException {
        block18: for (Map.Entry<String, Object> entry : claims.entrySet()) {
            switch (entry.getKey()) {
                case "aud": {
                    this.assertValidAudienceClaim(jwt.getAudience(), (List)entry.getValue());
                    continue block18;
                }
                case "exp": {
                    this.assertValidDateClaim(jwt.getExpiresAt(), (Long)entry.getValue(), true);
                    continue block18;
                }
                case "iat": {
                    this.assertValidDateClaim(jwt.getIssuedAt(), (Long)entry.getValue(), false);
                    continue block18;
                }
                case "nbf": {
                    this.assertValidDateClaim(jwt.getNotBefore(), (Long)entry.getValue(), false);
                    continue block18;
                }
                case "iss": {
                    this.assertValidIssuerClaim(jwt.getIssuer(), (List)entry.getValue());
                    continue block18;
                }
                case "jti": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getId(), (String)entry.getValue());
                    continue block18;
                }
                case "sub": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getSubject(), (String)entry.getValue());
                    continue block18;
                }
            }
            this.assertValidClaim(jwt.getClaim(entry.getKey()), entry.getKey(), entry.getValue());
        }
    }

    private void assertValidClaim(Claim claim, String claimName, Object value) {
        boolean isValid = false;
        if (value instanceof String) {
            isValid = value.equals(claim.asString());
        } else if (value instanceof Integer) {
            isValid = value.equals(claim.asInt());
        } else if (value instanceof Long) {
            isValid = value.equals(claim.asLong());
        } else if (value instanceof Boolean) {
            isValid = value.equals(claim.asBoolean());
        } else if (value instanceof Double) {
            isValid = value.equals(claim.asDouble());
        } else if (value instanceof Date) {
            isValid = value.equals(claim.asDate());
        } else if (value instanceof Object[]) {
            List<Object> claimArr;
            Object[] claimAsObject = claim.as(Object[].class);
            if (value instanceof Long[]) {
                claimArr = new ArrayList(claimAsObject.length);
                for (Object cao : claimAsObject) {
                    if (cao instanceof Integer) {
                        claimArr.add(((Integer)cao).longValue());
                        continue;
                    }
                    claimArr.add(cao);
                }
            } else {
                claimArr = claim.isNull() ? Collections.emptyList() : Arrays.asList(claim.as(Object[].class));
            }
            List<Object> valueArr = Arrays.asList((Object[])value);
            isValid = claimArr.containsAll(valueArr);
        }
        if (!isValid) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName));
        }
    }

    private void assertValidStringClaim(String claimName, String value, String expectedValue) {
        if (!expectedValue.equals(value)) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName));
        }
    }

    private void assertValidDateClaim(Date date, long leeway, boolean shouldBeFuture) {
        Date today = this.clock.getToday();
        today.setTime(today.getTime() / 1000L * 1000L);
        if (shouldBeFuture) {
            this.assertDateIsFuture(date, leeway, today);
        } else {
            this.assertDateIsPast(date, leeway, today);
        }
    }

    private void assertDateIsFuture(Date date, long leeway, Date today) {
        today.setTime(today.getTime() - leeway * 1000L);
        if (date != null && today.after(date)) {
            throw new TokenExpiredException(String.format("The Token has expired on %s.", date));
        }
    }

    private void assertDateIsPast(Date date, long leeway, Date today) {
        today.setTime(today.getTime() + leeway * 1000L);
        if (date != null && today.before(date)) {
            throw new InvalidClaimException(String.format("The Token can't be used before %s.", date));
        }
    }

    private void assertValidAudienceClaim(List<String> audience, List<String> value) {
        if (audience == null || !audience.containsAll(value)) {
            throw new InvalidClaimException("The Claim 'aud' value doesn't contain the required audience.");
        }
    }

    private void assertValidIssuerClaim(String issuer, List<String> value) {
        if (issuer == null || !value.contains(issuer)) {
            throw new InvalidClaimException("The Claim 'iss' value doesn't match the required issuer.");
        }
    }

    public static class BaseVerification
    implements Verification {
        private final Algorithm algorithm;
        private final Map<String, Object> claims;
        private long defaultLeeway;
        private boolean ignoreIssuedAt;

        BaseVerification(Algorithm algorithm) throws IllegalArgumentException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.algorithm = algorithm;
            this.claims = new HashMap<String, Object>();
            this.defaultLeeway = 0L;
        }

        @Override
        public Verification withIssuer(String ... issuer) {
            this.requireClaim("iss", issuer == null ? null : Arrays.asList(issuer));
            return this;
        }

        @Override
        public Verification withSubject(String subject) {
            this.requireClaim("sub", subject);
            return this;
        }

        @Override
        public Verification withAudience(String ... audience) {
            this.requireClaim("aud", audience == null ? null : Arrays.asList(audience));
            return this;
        }

        @Override
        public Verification acceptLeeway(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.defaultLeeway = leeway;
            return this;
        }

        @Override
        public Verification acceptExpiresAt(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.requireClaim("exp", leeway);
            return this;
        }

        @Override
        public Verification acceptNotBefore(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.requireClaim("nbf", leeway);
            return this;
        }

        @Override
        public Verification acceptIssuedAt(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.requireClaim("iat", leeway);
            return this;
        }

        @Override
        public Verification ignoreIssuedAt() {
            this.ignoreIssuedAt = true;
            return this;
        }

        @Override
        public Verification withJWTId(String jwtId) {
            this.requireClaim("jti", jwtId);
            return this;
        }

        @Override
        public Verification withClaim(String name, Boolean value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, value);
            return this;
        }

        @Override
        public Verification withClaim(String name, Integer value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, value);
            return this;
        }

        @Override
        public Verification withClaim(String name, Long value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, value);
            return this;
        }

        @Override
        public Verification withClaim(String name, Double value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, value);
            return this;
        }

        @Override
        public Verification withClaim(String name, String value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, value);
            return this;
        }

        @Override
        public Verification withClaim(String name, Date value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, value);
            return this;
        }

        @Override
        public Verification withArrayClaim(String name, String ... items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, items);
            return this;
        }

        @Override
        public Verification withArrayClaim(String name, Integer ... items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, items);
            return this;
        }

        @Override
        public Verification withArrayClaim(String name, Long ... items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.requireClaim(name, items);
            return this;
        }

        @Override
        public JWTVerifier build() {
            return this.build(new ClockImpl());
        }

        public JWTVerifier build(Clock clock) {
            this.addLeewayToDateClaims();
            return new JWTVerifier(this.algorithm, this.claims, clock);
        }

        private void assertPositive(long leeway) {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
        }

        private void assertNonNull(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The Custom Claim's name can't be null.");
            }
        }

        private void addLeewayToDateClaims() {
            if (!this.claims.containsKey("exp")) {
                this.claims.put("exp", this.defaultLeeway);
            }
            if (!this.claims.containsKey("nbf")) {
                this.claims.put("nbf", this.defaultLeeway);
            }
            if (this.ignoreIssuedAt) {
                this.claims.remove("iat");
                return;
            }
            if (!this.claims.containsKey("iat")) {
                this.claims.put("iat", this.defaultLeeway);
            }
        }

        private void requireClaim(String name, Object value) {
            if (value == null) {
                this.claims.remove(name);
                return;
            }
            this.claims.put(name, value);
        }
    }
}

