/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.nonxa.NonXAParticipant;
import com.atomikos.jdbc.nonxa.NonXAPooledConnectionImp;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.PooledConnection;

class ThreadLocalConnection
implements InvocationHandler {
    private static final List NON_TRANSACTIONAL_METHOD_NAMES = Arrays.asList("equals", "hashCode", "notify", "notifyAll", "toString", "wait");
    private int useCount = 0;
    private Connection wrapped;
    private NonXAPooledConnectionImp pooledConnection;
    private CompositeTransaction transaction;
    private boolean stale;
    private NonXAParticipant participant;

    static Object newInstance(NonXAPooledConnectionImp pooledConnection) throws SQLException {
        Connection obj = pooledConnection.getConnection();
        Set interfaces = ThreadLocalConnection.getAllImplementedInterfaces(obj.getClass());
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaceClasses, (InvocationHandler)new ThreadLocalConnection(pooledConnection));
    }

    static Set getAllImplementedInterfaces(Class clazz) {
        HashSet ret = null;
        ret = clazz.getSuperclass() != null ? ThreadLocalConnection.getAllImplementedInterfaces(clazz.getSuperclass()) : new HashSet();
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ret.add(interfaces[i]);
        }
        return ret;
    }

    private ThreadLocalConnection(NonXAPooledConnectionImp pooledConnection) throws SQLException {
        this.wrapped = pooledConnection.getConnection();
        this.pooledConnection = pooledConnection;
        this.setStale(false);
        this.resetForTransaction();
        this.updateInTransaction();
    }

    private void resetForTransaction() {
        this.setTransaction(null);
        this.participant = null;
    }

    private void setStale(boolean val) {
        this.stale = val;
    }

    boolean isStale() {
        return this.stale;
    }

    private void setTransaction(CompositeTransaction val) {
        this.transaction = val;
    }

    private void updateInTransaction() throws SQLException {
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            return;
        }
        CompositeTransaction ct = ctm.getCompositeTransaction();
        if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            if (this.isInTransaction() && !this.isInTransaction(ct)) {
                throw new SQLException("Connection accessed by transaction " + ct.getTid() + " is already in use in another transaction: " + this.transaction.getTid() + " Non-XA connections are not compatible with nested transaction use.");
            }
            this.setTransaction(ct);
            if (this.participant == null) {
                this.participant = new NonXAParticipant(this);
                ct.addParticipant((Participant)this.participant);
                this.wrapped.setAutoCommit(false);
            }
        } else if (this.isInTransaction()) {
            this.transactionTerminated(false);
        }
    }

    private boolean isInTransaction() {
        return this.transaction != null;
    }

    private boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (this.isInTransaction()) {
            ret = this.transaction.isSameTransaction(ct);
        }
        return ret;
    }

    private void decUseCount() {
        --this.useCount;
        this.checkReusability();
    }

    private void checkReusability() {
        if (this.useCount == 0 && !this.isInTransaction()) {
            Configuration.logDebug((String)"ThreadLocalConnection: detected reusability");
            this.setStale(true);
            this.pooledConnection.notifyCloseListeners();
        } else {
            Configuration.logDebug((String)"ThreadLocalConnection: not reusable yet");
        }
    }

    void addHeuristicMessage(HeuristicMessage msg) {
        if (this.participant != null) {
            this.participant.addHeuristicMessage(msg);
        }
    }

    void incUseCount() {
        ++this.useCount;
    }

    void transactionTerminated(boolean commit) throws SQLException {
        try {
            if (commit) {
                Configuration.logInfo((String)"ThreadLocalConnection: committing on connection...");
                this.wrapped.commit();
            } else {
                Configuration.logInfo((String)"ThreadLocalConnection: rolling back on connection...");
                this.wrapped.rollback();
            }
        }
        catch (SQLException e) {
            this.pooledConnection.setInvalidated();
            throw e;
        }
        finally {
            this.resetForTransaction();
            this.checkReusability();
        }
    }

    public Object invoke(Object o, Method m, Object[] args) throws Throwable {
        if (NON_TRANSACTIONAL_METHOD_NAMES.contains(m.getName())) {
            Configuration.logDebug((String)("Calling non-transactional method '" + m.getName() + "' on ThreadLocal connection, bypassing enlistment"));
            return m.invoke((Object)this.wrapped, args);
        }
        Object result = null;
        if (this.isStale()) {
            throw new SQLException("Attempt to use connection after it was closed.");
        }
        this.updateInTransaction();
        if (m.getName().equals("close")) {
            this.decUseCount();
        } else {
            if (this.isInTransaction() && (m.getName().equals("rollback") || m.getName().equals("commit"))) {
                throw new SQLException("Rollback or Commit not allowed inside a managed transaction!");
            }
            try {
                Configuration.logDebug((String)("ThreadLocalConnection: delegating method " + m + " to wrapped connection with args: " + args));
                result = m.invoke((Object)this.wrapped, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                Configuration.logDebug((String)"ThreadLocalConnection: Unexpected invocation exception", (Throwable)e);
                throw new RuntimeException("Unexpected invocation exception: " + e.getMessage());
            }
        }
        return result;
    }

    public boolean usesConnection(PooledConnection conn) {
        return this.pooledConnection.equals(conn);
    }
}

