/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.ConnectionPool;
import com.atomikos.jdbc.DTPPooledConnection;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.JtaDataSourceImpFactory;
import com.atomikos.jdbc.XAConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class JtaDataSourceImp
implements HeuristicDataSource,
ConnectionEventListener,
Referenceable,
ConnectionPoolDataSource {
    private static Map nameToDataSource_ = new HashMap();
    private ConnectionPool pool_;
    private TransactionalResource resource_;
    private XAConnectionFactory fact_;
    private boolean autoRegister_;

    static Reference createReference(String uniqueName) {
        StringRefAddr ra = new StringRefAddr("ResourceName", uniqueName);
        Class clazz = JtaDataSourceImp.class;
        Reference ref = new Reference(clazz.getName(), new StringRefAddr("name", "JtaDataSourceImp"), JtaDataSourceImpFactory.class.getName(), null);
        ref.add(ra);
        return ref;
    }

    static JtaDataSourceImp getInstance(String name) {
        JtaDataSourceImp ret = (JtaDataSourceImp)nameToDataSource_.get(name);
        return ret;
    }

    private static synchronized void addToMap(String name, JtaDataSourceImp instance) throws SQLException {
        if (nameToDataSource_.get(name) != null) {
            throw new SQLException("DataSource for resource " + name + " already exists!");
        }
        nameToDataSource_.put(name, instance);
    }

    private static synchronized void removeFromMap(String name) {
        if (name != null && nameToDataSource_ != null) {
            nameToDataSource_.remove(name);
        }
    }

    public JtaDataSourceImp(XAConnectionFactory fact, int poolSize, int connectionTimeout, String testQuery, boolean testOnBorrow) throws SQLException {
        this(fact, poolSize, connectionTimeout, false, false, testQuery, testOnBorrow);
    }

    JtaDataSourceImp(XAConnectionFactory fact, int poolSize, int connectionTimeout, boolean allowDuplicateNames, boolean registerWithTM, String testQuery, boolean testOnBorrow) throws SQLException {
        this.fact_ = fact;
        this.pool_ = new ConnectionPool(poolSize, fact, connectionTimeout, testQuery, testOnBorrow);
        this.resource_ = fact.getTransactionalResource();
        this.autoRegister_ = registerWithTM;
        if (!allowDuplicateNames) {
            JtaDataSourceImp.addToMap(this.resource_.getName(), this);
        }
        if (registerWithTM) {
            Configuration.addResource((RecoverableResource)this.resource_);
        }
    }

    public Connection getConnection() throws SQLException {
        HeuristicMessage msg = null;
        return this.getConnection(msg);
    }

    public Connection getConnection(String username, String passwd) throws SQLException {
        throw new SQLException("Not supported: getConnection ( user , passwd )");
    }

    public Connection getConnection(String user, String passwd, HeuristicMessage msg) throws SQLException {
        throw new SQLException("Not supported: getConnection ( user , passwd )");
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pool_.getLogWriter();
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.pool_.setLogWriter(pw);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.pool_.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.pool_.getLoginTimeout();
    }

    public void close() {
        this.pool_.cleanup();
        JtaDataSourceImp.removeFromMap(this.resource_.getName());
        if (this.autoRegister_) {
            Configuration.removeResource((String)this.resource_.getName());
        }
    }

    public TransactionalResource getTransactionalResource() {
        return this.resource_;
    }

    public Reference getReference() throws NamingException {
        return JtaDataSourceImp.createReference(this.resource_.getName());
    }

    public Connection getConnection(HeuristicMessage msg) throws SQLException {
        DTPPooledConnection ret = (DTPPooledConnection)this.pool_.getPooledConnection();
        ret.addConnectionEventListener(this);
        return ret.getConnection(msg);
    }

    public void connectionClosed(ConnectionEvent arg) {
        DTPPooledConnection pc = (DTPPooledConnection)arg.getSource();
        if (pc.isDiscarded()) {
            pc.removeConnectionEventListener(this);
            this.pool_.putBack(pc);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent arg) {
        DTPPooledConnection pc = (DTPPooledConnection)arg.getSource();
        pc.removeConnectionEventListener(this);
        pc.setInvalidated();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.fact_.getPooledConnection();
    }

    public PooledConnection getPooledConnection(String user, String pw) throws SQLException {
        throw new SQLException("Not supported.");
    }

    public Connection getConnection(String msg) throws SQLException {
        StringHeuristicMessage hm = new StringHeuristicMessage(msg);
        return this.getConnection((HeuristicMessage)hm);
    }

    public Connection getConnection(String user, String passwd, String msg) throws SQLException {
        StringHeuristicMessage hm = new StringHeuristicMessage(msg);
        return this.getConnection(user, passwd, (HeuristicMessage)hm);
    }
}

