/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.DataSourceShutdownHook;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.JtaDataSourceImp;
import com.atomikos.jdbc.XAConnectionFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XADataSource;

public class DataSourceBean
implements HeuristicDataSource,
Serializable,
Referenceable {
    private transient JtaDataSourceImp ds_ = null;
    private XADataSource xads_ = null;
    private String xadsJndiName_ = "";
    private String resourceName_ = "someUniqueName";
    private String xidFactory_ = "Default";
    private int poolSize_ = 2;
    private int connectionTimeout_ = 30;
    private boolean exclusive_ = true;
    private String validatingQuery_ = "";
    private boolean testOnBorrow_ = false;

    private synchronized void checkSetup(boolean validation) throws SQLException {
        this.ds_ = JtaDataSourceImp.getInstance(this.getUniqueResourceName());
        if (this.ds_ != null && !validation) {
            return;
        }
        if (this.xads_ == null && this.getDataSourceName().equals("")) {
            throw new SQLException("DataSourceBean: xaDataSource not set.");
        }
        if (this.xidFactory_ == null) {
            throw new SQLException("DataSourceBean: xidFormat not set.");
        }
        if (!validation && !this.getDataSourceName().equals("")) {
            try {
                InitialContext ctx = new InitialContext();
                Context envCtx = (Context)ctx.lookup("java:comp/env");
                this.xads_ = (XADataSource)envCtx.lookup(this.getDataSourceName());
            }
            catch (Exception e) {
                throw new SQLException("DataSourceBean: setup error: " + e.getClass().getName() + " " + e.getMessage());
            }
        }
        DefaultXidFactory xidFactory = null;
        xidFactory = new DefaultXidFactory();
        XAConnectionFactory factory = new XAConnectionFactory(this.resourceName_, "", "", this.xads_, (XidFactory)xidFactory);
        factory.setExclusive(this.exclusive_);
        this.ds_ = new JtaDataSourceImp(factory, this.poolSize_, this.connectionTimeout_, validation, !validation, this.validatingQuery_, this.testOnBorrow_);
        DataSourceShutdownHook hook = new DataSourceShutdownHook(this.ds_);
        Configuration.addShutdownHook((Thread)hook);
    }

    private synchronized void checkSetup() throws SQLException {
        this.checkSetup(false);
    }

    public void setTestOnBorrow(String value) {
        this.testOnBorrow_ = "true".equals(value);
    }

    public String getTestOnBorrow() {
        return this.testOnBorrow_ + "";
    }

    public void setDataSourceName(String name) {
        this.xadsJndiName_ = name;
    }

    public String getDataSourceName() {
        return this.xadsJndiName_;
    }

    public void setXaDataSource(XADataSource xads) {
        this.xads_ = xads;
    }

    public XADataSource getXaDataSource() {
        return this.xads_;
    }

    public void setUniqueResourceName(String resourceName) {
        this.resourceName_ = resourceName;
    }

    public String getUniqueResourceName() {
        return this.resourceName_;
    }

    public void setXidFormat(String factory) {
        this.xidFactory_ = factory;
    }

    public String getXidFormat() {
        return this.xidFactory_;
    }

    public void setConnectionPoolSize(String poolSize) {
        this.poolSize_ = Integer.parseInt(poolSize);
    }

    public String getConnectionPoolSize() {
        return "" + this.poolSize_;
    }

    public void setConnectionTimeout(String timeout) {
        this.connectionTimeout_ = Integer.parseInt(timeout);
    }

    public String getConnectionTimeout() {
        return "" + this.connectionTimeout_;
    }

    public void setExclusiveConnectionMode(String mode) {
        this.exclusive_ = "true".equals(mode);
    }

    public String isExclusiveConnectionMode() {
        return "" + this.exclusive_;
    }

    public TransactionalResource getTransactionalResource() {
        try {
            this.checkSetup();
        }
        catch (SQLException err) {
            err.printStackTrace();
            throw new RuntimeException(err.getMessage());
        }
        return this.ds_.getTransactionalResource();
    }

    public void setValidatingQuery(String query) {
        this.validatingQuery_ = query;
    }

    public String getValidatingQuery() {
        return this.validatingQuery_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String query = this.getValidatingQuery();
        if (query == null || query.equals("")) {
            return;
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds_.getConnection();
            try {
                s = c.createStatement();
                ResultSet rs = s.executeQuery(query);
                s.close();
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection();
    }

    public Connection getConnection(String user, String pw) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(user, pw);
    }

    public Connection getConnection(HeuristicMessage msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(msg);
    }

    public Connection getConnection(String msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(msg);
    }

    public Connection getConnection(String user, String passwd, String msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(user, passwd, msg);
    }

    public Connection getConnection(String user, String pw, HeuristicMessage msg) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(user, pw, msg);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup();
        return this.ds_.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup();
        return this.ds_.getLogWriter();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.checkSetup();
        this.ds_.setLoginTimeout(seconds);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.checkSetup();
        this.ds_.setLogWriter(out);
    }

    public void close() throws SQLException {
        if (this.ds_ != null) {
            this.ds_.close();
        }
    }

    public Reference getReference() throws NamingException {
        return JtaDataSourceImp.createReference(this.getUniqueResourceName());
    }
}

