/*
 * Decompiled with CFR 0.152.
 */
package com.arturmkrtchyan.kafka.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarUnpacker {
    private static final int BUFFER_SIZE = 8192;

    public boolean unpack(Path archivePath, Path outputPath, boolean isGzipped) throws IOException {
        boolean result = false;
        try (InputStream inputStream = Files.newInputStream(archivePath, new OpenOption[0]);
             TarArchiveInputStream tarArchiveInputStream = this.createTarArchiveInputStream(inputStream, isGzipped);){
            result = this.unpack(tarArchiveInputStream, outputPath);
        }
        return result;
    }

    protected TarArchiveInputStream createTarArchiveInputStream(InputStream inputStream, boolean isGzipped) throws IOException {
        return isGzipped ? new TarArchiveInputStream((InputStream)new GZIPInputStream(inputStream), 8192) : new TarArchiveInputStream((InputStream)new BufferedInputStream(inputStream), 8192);
    }

    protected boolean unpack(TarArchiveInputStream in, Path outputPath) throws IOException {
        TarArchiveEntry entry;
        while ((entry = in.getNextTarEntry()) != null) {
            Path entryPath = outputPath.resolve(entry.getName());
            if (entry.isDirectory()) {
                if (Files.exists(entryPath, new LinkOption[0])) continue;
                Files.createDirectories(entryPath, new FileAttribute[0]);
                continue;
            }
            if (!entry.isFile()) continue;
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(entryPath, new OpenOption[0]));
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
                this.setPermissions(entry.getMode(), entryPath);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((OutputStream)out).close();
            }
        }
        return true;
    }

    protected void setPermissions(int mode, Path path) throws IOException {
        PosixFileAttributeView attributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (attributeView != null) {
            attributeView.setPermissions(PosixFilePermissionConverter.convertToPermissionsSet(mode));
        }
    }

    private static class PosixFilePermissionConverter {
        private PosixFilePermissionConverter() {
        }

        static Set<PosixFilePermission> convertToPermissionsSet(int mode) {
            EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
            if (PosixFilePermissionConverter.isSet(mode, 256)) {
                result.add(PosixFilePermission.OWNER_READ);
            }
            if (PosixFilePermissionConverter.isSet(mode, 128)) {
                result.add(PosixFilePermission.OWNER_WRITE);
            }
            if (PosixFilePermissionConverter.isSet(mode, 64)) {
                result.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if (PosixFilePermissionConverter.isSet(mode, 32)) {
                result.add(PosixFilePermission.GROUP_READ);
            }
            if (PosixFilePermissionConverter.isSet(mode, 16)) {
                result.add(PosixFilePermission.GROUP_WRITE);
            }
            if (PosixFilePermissionConverter.isSet(mode, 8)) {
                result.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if (PosixFilePermissionConverter.isSet(mode, 4)) {
                result.add(PosixFilePermission.OTHERS_READ);
            }
            if (PosixFilePermissionConverter.isSet(mode, 2)) {
                result.add(PosixFilePermission.OTHERS_WRITE);
            }
            if (PosixFilePermissionConverter.isSet(mode, 1)) {
                result.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            return result;
        }

        private static boolean isSet(int mode, int testbit) {
            return (mode & testbit) == testbit;
        }

        public static int convertToInt(Set<PosixFilePermission> permissions) {
            int result = 0;
            if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
                result |= 0x100;
            }
            if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                result |= 0x80;
            }
            if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                result |= 0x40;
            }
            if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
                result |= 0x20;
            }
            if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                result |= 0x10;
            }
            if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                result |= 8;
            }
            if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
                result |= 4;
            }
            if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                result |= 2;
            }
            if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                result |= 1;
            }
            return result;
        }
    }
}

