/*
 * Decompiled with CFR 0.152.
 */
package com.arturmkrtchyan.kafka.util;

import com.github.kevinsawicki.http.HttpRequest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ApacheProjectDownloader {
    public Path download(String url, String projectName, Path directory) throws IOException, RuntimeException {
        Path projectPath = directory.resolve(projectName);
        this.createDirectory(directory);
        this.download(url, projectPath);
        return projectPath;
    }

    private void download(String url, Path projectPath) throws IOException, RuntimeException {
        HttpRequest request = HttpRequest.get((CharSequence)url);
        if (!request.ok() || request.contentLength() <= 0) {
            throw new RuntimeException(String.format("Unable to download kafka from %s, to %s", url, projectPath.getParent().toString()));
        }
        Files.createFile(projectPath, new FileAttribute[0]);
        request.receive(projectPath.toFile());
    }

    private void createDirectory(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }
}

