/*
 * Decompiled with CFR 0.152.
 */
package com.arturmkrtchyan.kafka;

import com.arturmkrtchyan.kafka.KafkaInstance;
import com.arturmkrtchyan.kafka.KafkaPluginException;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;

public class KafkaManager {
    final Logger logger = LoggerFactory.getLogger(KafkaManager.class);

    public void startKafka(KafkaInstance instance) {
        try {
            this.executeInBackground(instance.getStartupScript().toString(), instance.getConfig().toString());
            this.wait(7, TimeUnit.SECONDS);
            this.logger.debug(this.execute("jps", "-v"));
        }
        catch (Exception e) {
            throw new KafkaPluginException(String.format("Unable to start kafka instance based on %s", instance.getPath().toString()), e);
        }
    }

    public void stopKafka(KafkaInstance instance) {
        try {
            this.executeInBackground(instance.getShutdownScript().toString());
            this.wait(5, TimeUnit.SECONDS);
            this.logger.debug(this.execute("jps", "-v"));
        }
        catch (Exception e) {
            throw new KafkaPluginException(String.format("Unable to stop kafka instance based on %s", instance.getPath().toString()), e);
        }
    }

    protected void startZookeeper(KafkaInstance instance) {
        try {
            this.executeInBackground(instance.getZookeeperStartupScript().toString(), instance.getZookeeperConfig().toString());
            this.wait(7, TimeUnit.SECONDS);
            this.logger.debug(this.execute("jps", "-v"));
        }
        catch (Exception e) {
            throw new KafkaPluginException(String.format("Unable to start zookeeper instance based on %s", instance.getPath().toString()), e);
        }
    }

    protected void stopZookeeper(KafkaInstance instance) {
        try {
            this.executeInBackground(instance.getZookeeperShutdownScript().toString());
            this.wait(5, TimeUnit.SECONDS);
            this.logger.debug(this.execute("jps", "-v"));
        }
        catch (Exception e) {
            throw new KafkaPluginException(String.format("Unable to stop zookeeper instance based on %s", instance.getPath().toString()), e);
        }
    }

    private void wait(int seconds, TimeUnit unit) {
        try {
            unit.sleep(seconds);
        }
        catch (InterruptedException e) {
            this.logger.warn("Thread was interupted.", (Throwable)e);
        }
    }

    private void executeInBackground(String ... commands) throws IOException {
        new ProcessExecutor().command(Arrays.asList(commands)).start();
    }

    private String execute(String ... commands) throws InterruptedException, TimeoutException, IOException {
        return new ProcessExecutor().command(Arrays.asList(commands)).readOutput(true).execute().outputUTF8();
    }
}

