/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.annotations.NonNull;
import com.android.sdklib.repository.FullRevision;

public class PreciseRevision
extends FullRevision {
    private final int mPrecision;

    @NonNull
    public static PreciseRevision parseRevision(@NonNull String revision) throws NumberFormatException {
        return (PreciseRevision)PreciseRevision.parseRevisionImpl(revision, true, true, true);
    }

    public PreciseRevision(int major) {
        this(major, 0, 0, 0, 1, " ");
    }

    public PreciseRevision(int major, int minor) {
        this(major, minor, 0, 0, 2, " ");
    }

    public PreciseRevision(int major, int minor, int micro) {
        this(major, minor, micro, 0, 3, " ");
    }

    public PreciseRevision(int major, int minor, int micro, int preview) {
        this(major, minor, micro, preview, 4, " ");
    }

    PreciseRevision(int major, int minor, int micro, int preview, int precision, String separator) {
        this(major, minor, micro, preview, precision, separator, FullRevision.PreviewType.RC);
    }

    PreciseRevision(int major, int minor, int micro, int preview, int precision, String separator, FullRevision.PreviewType previewType) {
        super(major, minor, micro, previewType, preview, separator);
        this.mPrecision = precision;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajor());
        if (this.mPrecision >= 2) {
            sb.append('.').append(this.getMinor());
            if (this.mPrecision >= 3) {
                sb.append('.').append(this.getMicro());
                if (this.mPrecision >= 4 && this.isPreview()) {
                    sb.append(this.getSeparator()).append("rc").append(this.getPreview());
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return this.toString();
    }

    @Override
    public int[] toIntArray(boolean includePreview) {
        int[] result;
        if (this.mPrecision >= 4 && this.isPreview()) {
            if (includePreview) {
                result = new int[this.mPrecision];
                result[3] = this.getPreview();
            } else {
                result = new int[this.mPrecision - 1];
            }
        } else {
            result = new int[this.mPrecision];
        }
        result[0] = this.getMajor();
        if (this.mPrecision >= 2) {
            result[1] = this.getMinor();
            if (this.mPrecision >= 3) {
                result[2] = this.getMicro();
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.mPrecision;
    }

    @Override
    public boolean equals(Object rhs) {
        boolean equals = super.equals(rhs);
        if (equals) {
            if (!(rhs instanceof PreciseRevision)) {
                return false;
            }
            PreciseRevision other = (PreciseRevision)rhs;
            return this.mPrecision == other.mPrecision;
        }
        return false;
    }

    public int compareTo(PreciseRevision rhs, FullRevision.PreviewComparison comparePreview) {
        int delta = super.compareTo(rhs, comparePreview);
        if (delta == 0) {
            return this.mPrecision - rhs.mPrecision;
        }
        return delta;
    }
}

