/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.resources.Density;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SplitOutputMatcher {
    @NonNull
    public static List<OutputFile> computeBestOutput(@NonNull List<? extends VariantOutput> outputs, @Nullable Set<String> variantAbiFilters, int deviceDensity, @Nullable String language, @Nullable String region, @NonNull List<String> deviceAbis) {
        Density densityEnum = Density.getEnum((int)deviceDensity);
        String densityValue = densityEnum == null ? null : densityEnum.getResourceValue();
        HashSet<VariantOutput> matches = new HashSet<VariantOutput>();
        for (VariantOutput variantOutput : outputs) {
            for (OutputFile output : variantOutput.getOutputs()) {
                String densityFilter = SplitOutputMatcher.getFilter(output, OutputFile.DENSITY);
                String abiFilter = SplitOutputMatcher.getFilter(output, OutputFile.ABI);
                if (densityFilter != null && !densityFilter.equals(densityValue) || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
                matches.add(variantOutput);
            }
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        VariantOutput match = Collections.max(matches, new Comparator<VariantOutput>(){

            @Override
            public int compare(VariantOutput splitOutput, VariantOutput splitOutput2) {
                return splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            }
        });
        OutputFile outputFile = match.getMainOutputFile();
        if (match.getOutputs().size() == 1) {
            return SplitOutputMatcher.isMainApkCompatibleWithDevice(outputFile, variantAbiFilters, deviceAbis) ? ImmutableList.of((Object)outputFile) : ImmutableList.of();
        }
        ImmutableList.Builder apks = ImmutableList.builder();
        apks.add((Object)outputFile);
        SplitOutputMatcher.addIfPresent((ImmutableList.Builder<OutputFile>)apks, SplitOutputMatcher.findAbiCompatibleSplitApk(match, deviceAbis));
        SplitOutputMatcher.addIfPresent((ImmutableList.Builder<OutputFile>)apks, SplitOutputMatcher.findDensityCompatibleSplitApk(match, densityValue));
        if (language != null) {
            apks.addAll(SplitOutputMatcher.findLocaleCompatibleSplitApk(match, language, region));
        }
        return apks.build();
    }

    private static void addIfPresent(ImmutableList.Builder<OutputFile> apks, Optional<OutputFile> optionalOutputFile) {
        if (optionalOutputFile.isPresent()) {
            apks.add(optionalOutputFile.get());
        }
    }

    private static boolean isMainApkCompatibleWithDevice(OutputFile mainOutputFile, Set<String> variantAbiFilters, List<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, OutputFile.ABI) == null && variantAbiFilters != null) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static Optional<OutputFile> findAbiCompatibleSplitApk(VariantOutput variantOutput, List<String> deviceAbis) {
        for (String deviceAbi : deviceAbis) {
            for (OutputFile outputFile : variantOutput.getOutputs()) {
                if (!outputFile.getOutputType().equals(OutputFile.SPLIT) || !deviceAbi.equals(SplitOutputMatcher.getFilter(outputFile, OutputFile.ABI))) continue;
                return Optional.of((Object)outputFile);
            }
        }
        return Optional.absent();
    }

    private static Optional<OutputFile> findDensityCompatibleSplitApk(VariantOutput variantOutput, String densityValue) {
        for (OutputFile outputFile : variantOutput.getOutputs()) {
            if (!outputFile.getOutputType().equals(OutputFile.SPLIT) || !densityValue.equals(SplitOutputMatcher.getFilter(outputFile, OutputFile.DENSITY))) continue;
            return Optional.of((Object)outputFile);
        }
        return Optional.absent();
    }

    private static List<OutputFile> findLocaleCompatibleSplitApk(@NonNull VariantOutput variantOutput, @NonNull String deviceLanguage, @Nullable String deviceRegion) {
        ImmutableList<LocaleApk> languageCompatibleApks = SplitOutputMatcher.findLanguageCompatibleSplitApks(variantOutput, deviceLanguage);
        ImmutableList.Builder regionCompatibleApks = ImmutableList.builder();
        LocaleApk genericRegionApk = null;
        for (LocaleApk localeApk : languageCompatibleApks) {
            if (Objects.equal((Object)deviceRegion, (Object)localeApk.mRegion)) {
                regionCompatibleApks.add((Object)localeApk.mOutputFile);
            }
            if (localeApk.mRegion != null) continue;
            genericRegionApk = localeApk;
        }
        if (genericRegionApk != null && deviceRegion != null) {
            regionCompatibleApks.add((Object)genericRegionApk.mOutputFile);
        }
        return regionCompatibleApks.build();
    }

    private static ImmutableList<LocaleApk> findLanguageCompatibleSplitApks(VariantOutput variantOutput, String deviceLanguage) {
        ImmutableList.Builder compatibleApks = ImmutableList.builder();
        for (OutputFile outputFile : variantOutput.getOutputs()) {
            String languagesAndOptionalRegions;
            if (!outputFile.getOutputType().equals(OutputFile.SPLIT) || (languagesAndOptionalRegions = SplitOutputMatcher.getFilter(outputFile, OutputFile.LANGUAGE)) == null) continue;
            Splitter splitter = Splitter.on((char)'_');
            for (String languageAndOptionRegion : splitter.splitToList((CharSequence)languagesAndOptionalRegions)) {
                String splitLanguage;
                String splitRegion = null;
                if (languageAndOptionRegion.indexOf(45) != -1) {
                    splitLanguage = languageAndOptionRegion.substring(0, languageAndOptionRegion.indexOf(45));
                    splitRegion = languageAndOptionRegion.substring(languageAndOptionRegion.indexOf(45) + 1);
                } else {
                    splitLanguage = languageAndOptionRegion;
                }
                if (!deviceLanguage.equals(splitLanguage)) continue;
                compatibleApks.add((Object)new LocaleApk(outputFile, splitLanguage, splitRegion));
            }
        }
        return compatibleApks.build();
    }

    @Nullable
    private static String getFilter(@NonNull OutputFile outputFile, @NonNull String filterType) {
        for (FilterData filterData : outputFile.getFilters()) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }

    private static class LocaleApk {
        @NonNull
        private final OutputFile mOutputFile;
        @NonNull
        private final String mLanguage;
        @Nullable
        private final String mRegion;

        private LocaleApk(@NonNull OutputFile outputFile, @NonNull String language, @Nullable String region) {
            this.mOutputFile = outputFile;
            this.mLanguage = language;
            this.mRegion = region;
        }
    }
}

