/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.MergeConsumer;
import java.io.File;
import java.util.concurrent.ExecutionException;

public abstract class MergeWriter<I extends DataItem>
implements MergeConsumer<I> {
    @NonNull
    private final File mRootFolder;
    @NonNull
    private final WaitableExecutor<Void> mExecutor;

    public MergeWriter(@NonNull File rootFolder) {
        this.mRootFolder = rootFolder;
        this.mExecutor = new WaitableExecutor();
    }

    @Override
    public void start() throws MergeConsumer.ConsumerException {
    }

    @Override
    public void end() throws MergeConsumer.ConsumerException {
        try {
            this.postWriteAction();
            this.getExecutor().waitForTasksWithQuickFail();
        }
        catch (InterruptedException e) {
            this.getExecutor().cancelAllTasks();
            throw new MergeConsumer.ConsumerException(e);
        }
        catch (ExecutionException e) {
            this.mExecutor.cancelAllTasks();
            throw new MergeConsumer.ConsumerException(e.getCause());
        }
    }

    protected void postWriteAction() throws MergeConsumer.ConsumerException {
    }

    @NonNull
    protected WaitableExecutor<Void> getExecutor() {
        return this.mExecutor;
    }

    @NonNull
    protected File getRootFolder() {
        return this.mRootFolder;
    }
}

