/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.ast.AstVisitor;
import lombok.ast.Cast;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ViewTypeDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"WrongViewCast", (String)"Mismatched view type", (String)"Keeps track of the view types associated with ids and if it finds a usage of the id in the Java code it ensures that it is treated as the same type.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.FATAL, (Implementation)new Implementation(ViewTypeDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES), new EnumSet[]{Scope.JAVA_FILE_SCOPE}));
    private Boolean mIgnore = null;
    private final Map<String, Object> mIdToViewTag = new HashMap<String, Object>(50);
    private Map<File, Multimap<String, String>> mFileIdMap;

    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String view = attribute.getOwnerElement().getTagName();
        String value = attribute.getValue();
        String id = null;
        if (value.startsWith("@id/")) {
            id = value.substring("@id/".length());
        } else if (value.startsWith("@+id/")) {
            id = value.substring("@+id/".length());
        }
        if (id != null) {
            List list;
            Object existing;
            if (view.equals("view")) {
                view = attribute.getOwnerElement().getAttribute("class");
            }
            if ((existing = this.mIdToViewTag.get(id)) == null) {
                this.mIdToViewTag.put(id, view);
            } else if (existing instanceof String) {
                String existingString = (String)existing;
                if (!existingString.equals(view)) {
                    ArrayList<String> list2 = new ArrayList<String>(2);
                    list2.add((String)existing);
                    list2.add(view);
                    this.mIdToViewTag.put(id, list2);
                }
            } else if (existing instanceof List && !(list = (List)existing).contains(view)) {
                list.add(view);
            }
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("findViewById");
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        LintClient client = context.getClient();
        if (this.mIgnore == Boolean.TRUE) {
            return;
        }
        if (this.mIgnore == null) {
            this.mIgnore = !context.getScope().contains(Scope.ALL_RESOURCE_FILES) && !client.supportsProjectResources();
            if (this.mIgnore.booleanValue()) {
                return;
            }
        }
        assert (node.astName().astValue().equals("findViewById"));
        if (node.getParent() instanceof Cast) {
            String resource;
            Expression first;
            Cast cast = (Cast)node.getParent();
            String castType = cast.astTypeReference().getTypeName();
            StrictListAccessor args = node.astArguments();
            if (args.size() == 1 && (first = (Expression)args.first()) instanceof Select && (resource = first.toString()).startsWith("R.id.")) {
                String id = ((Select)first).astIdentifier().astValue();
                if (client.supportsProjectResources()) {
                    AbstractResourceRepository resources = client.getProjectResources(context.getMainProject(), true);
                    if (resources == null) {
                        return;
                    }
                    List items = resources.getResourceItem(ResourceType.ID, id);
                    if (items != null && !items.isEmpty()) {
                        HashSet compatible = Sets.newHashSet();
                        for (ResourceItem item : items) {
                            Collection<String> tags = this.getViewTags((Context)context, item);
                            if (tags == null) continue;
                            compatible.addAll(tags);
                        }
                        if (!compatible.isEmpty()) {
                            ArrayList layoutTypes = Lists.newArrayList((Iterable)compatible);
                            ViewTypeDetector.checkCompatible(context, castType, null, layoutTypes, cast);
                        }
                    }
                } else {
                    Object types = this.mIdToViewTag.get(id);
                    if (types instanceof String) {
                        String layoutType = (String)types;
                        ViewTypeDetector.checkCompatible(context, castType, layoutType, null, cast);
                    } else if (types instanceof List) {
                        List layoutTypes = (List)types;
                        ViewTypeDetector.checkCompatible(context, castType, null, layoutTypes, cast);
                    }
                }
            }
        }
    }

    @Nullable
    protected Collection<String> getViewTags(@NonNull Context context, @NonNull ResourceItem item) {
        File file;
        Multimap<String, String> map;
        ResourceFile source = (ResourceFile)item.getSource();
        if (source != null && (map = this.getIdToTagsIn(context, file = source.getFile())) != null) {
            return map.get((Object)item.getName());
        }
        return null;
    }

    @Nullable
    private Multimap<String, String> getIdToTagsIn(@NonNull Context context, @NonNull File file) {
        ArrayListMultimap map;
        if (!file.getPath().endsWith(".xml")) {
            return null;
        }
        if (this.mFileIdMap == null) {
            this.mFileIdMap = Maps.newHashMap();
        }
        if ((map = this.mFileIdMap.get(file)) == null) {
            map = ArrayListMultimap.create();
            this.mFileIdMap.put(file, (Multimap<String, String>)map);
            String xml = context.getClient().readFile(file);
            Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            if (document != null && document.getDocumentElement() != null) {
                ViewTypeDetector.addViewTags((Multimap<String, String>)map, document.getDocumentElement());
            }
        }
        return map;
    }

    private static void addViewTags(Multimap<String, String> map, Element element) {
        String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if (id != null && !id.isEmpty() && !map.containsEntry((Object)(id = LintUtils.stripIdPrefix((String)id)), (Object)element.getTagName())) {
            map.put((Object)id, (Object)element.getTagName());
        }
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            ViewTypeDetector.addViewTags(map, (Element)child);
        }
    }

    private static void checkCompatible(JavaContext context, String castType, String layoutType, List<String> layoutTypes, Cast node) {
        boolean compatible;
        block6: {
            block5: {
                assert (layoutType == null || layoutTypes == null);
                compatible = true;
                if (layoutType == null) break block5;
                if (layoutType.equals(castType) || context.getSdkInfo().isSubViewOf(castType, layoutType)) break block6;
                compatible = false;
                break block6;
            }
            compatible = false;
            assert (layoutTypes != null);
            for (String type : layoutTypes) {
                if (!type.equals(castType) && !context.getSdkInfo().isSubViewOf(castType, type)) continue;
                compatible = true;
                break;
            }
        }
        if (!compatible) {
            if (layoutType == null) {
                layoutType = Joiner.on((String)"|").join(layoutTypes);
            }
            String message = String.format("Unexpected cast to `%1$s`: layout tag was `%2$s`", castType, layoutType);
            context.report(ISSUE, (Node)node, context.getLocation((Node)node), message);
        }
    }
}

