/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.DexOptions;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.dependency.SymbolFileProvider;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.incremental.DependencyData;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.internal.packaging.Packager;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ClassField;
import com.android.builder.model.PackagingOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.packaging.SigningException;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.internal.AaptCruncher;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergerLog;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AndroidBuilder {
    private static final FullRevision MIN_BUILD_TOOLS_REV = new FullRevision(19, 1, 0);
    private static final DependencyFileProcessor sNoOpDependencyFileProcessor = new DependencyFileProcessor(){

        @Override
        public DependencyData processFile(@NonNull File dependencyFile) {
            return null;
        }
    };
    private final String mProjectId;
    private final ILogger mLogger;
    private final CommandLineRunner mCmdLineRunner;
    private final boolean mVerboseExec;
    private String mCreatedBy;
    private SdkInfo mSdkInfo;
    private TargetInfo mTargetInfo;

    public AndroidBuilder(@NonNull String projectId, @Nullable String createdBy, @NonNull ILogger logger, boolean verboseExec) {
        this.mProjectId = projectId;
        this.mCreatedBy = createdBy;
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
        this.mCmdLineRunner = new CommandLineRunner(this.mLogger);
    }

    AndroidBuilder(@NonNull String projectId, @NonNull CommandLineRunner cmdLineRunner, @NonNull ILogger logger, boolean verboseExec) {
        this.mProjectId = projectId;
        this.mCmdLineRunner = (CommandLineRunner)Preconditions.checkNotNull((Object)cmdLineRunner);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
    }

    public void setTargetInfo(@NonNull SdkInfo sdkInfo, @NonNull TargetInfo targetInfo) {
        this.mSdkInfo = sdkInfo;
        this.mTargetInfo = targetInfo;
        if (this.mTargetInfo.getBuildTools().getRevision().compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Build Tools revision (%1$s) is too low for project '%2$s'. Minimum required is %3$s", this.mTargetInfo.getBuildTools().getRevision(), this.mProjectId, MIN_BUILD_TOOLS_REV));
        }
    }

    @Nullable
    public SdkInfo getSdkInfo() {
        return this.mSdkInfo;
    }

    @Nullable
    public TargetInfo getTargetInfo() {
        return this.mTargetInfo;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTarget() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget();
    }

    public boolean isPreviewTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call isTargetAPreview() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().isPreview();
    }

    public String getTargetCodename() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTargetCodename() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().getCodename();
    }

    @NonNull
    public List<String> getBootClasspath() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
        ArrayList classpath = Lists.newArrayList();
        IAndroidTarget target = this.mTargetInfo.getTarget();
        classpath.addAll(target.getBootClasspath());
        IAndroidTarget.IOptionalLibrary[] libs = target.getOptionalLibraries();
        if (libs != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                classpath.add(lib.getJarPath());
            }
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add(this.mSdkInfo.getAnnotationsJar().getPath());
        }
        return classpath;
    }

    @Nullable
    public File getRenderScriptSupportJar() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportJar(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    @NonNull
    public Set<File> getCompileClasspath(@NonNull VariantConfiguration variantConfiguration) {
        HashSet compileClasspath = variantConfiguration.getCompileClasspath();
        DefaultProductFlavor mergedFlavor = variantConfiguration.getMergedFlavor();
        if (mergedFlavor.getRenderscriptSupportMode()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            HashSet fullJars = Sets.newHashSetWithExpectedSize((int)(compileClasspath.size() + 1));
            fullJars.addAll(compileClasspath);
            if (renderScriptSupportJar != null) {
                fullJars.add(renderScriptSupportJar);
            }
            compileClasspath = fullJars;
        }
        return compileClasspath;
    }

    @NonNull
    public Set<File> getPackagedJars(@NonNull VariantConfiguration variantConfiguration) {
        HashSet packagedJars = variantConfiguration.getPackagedJars();
        DefaultProductFlavor mergedFlavor = variantConfiguration.getMergedFlavor();
        if (mergedFlavor.getRenderscriptSupportMode()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            HashSet fullJars = Sets.newHashSetWithExpectedSize((int)(packagedJars.size() + 1));
            fullJars.addAll(packagedJars);
            if (renderScriptSupportJar != null) {
                fullJars.add(renderScriptSupportJar);
            }
            packagedJars = fullJars;
        }
        return packagedJars;
    }

    @Nullable
    public File getSupportNativeLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportNativeLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    @NonNull
    public PngCruncher getAaptCruncher() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getAaptCruncher() before setTargetInfo() is called.");
        return new AaptCruncher(this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.AAPT), this.mCmdLineRunner);
    }

    @NonNull
    public CommandLineRunner getCommandLineRunner() {
        return this.mCmdLineRunner;
    }

    @NonNull
    public static ClassField createClassField(@NonNull String type, @NonNull String name, @NonNull String value) {
        return new ClassFieldImpl(type, name, value);
    }

    public void mergeManifests(@NonNull File mainManifest, @NonNull List<File> manifestOverlays, @NonNull List<? extends ManifestDependency> libraries, String packageOverride, int versionCode, String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @Nullable Integer maxSdkVersion, @NonNull String outManifestLocation, ManifestMerger2.MergeType mergeType, Map<String, String> placeHolders) {
        try {
            ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(manifestOverlays.toArray(new File[manifestOverlays.size()])).addLibraryManifests(AndroidBuilder.collectLibraries(libraries));
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            AndroidBuilder.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode, versionName, minSdkVersion, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            this.mLogger.info("Merging result:" + mergingReport.getResult(), new Object[0]);
            switch (mergingReport.getResult()) {
                case WARNING: {
                    mergingReport.log(this.mLogger);
                }
                case SUCCESS: {
                    XmlDocument xmlDocument = (XmlDocument)mergingReport.getMergedDocument().get();
                    try {
                        String annotatedDocument = mergingReport.getActions().blame(xmlDocument);
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    }
                    catch (Exception e) {
                        this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                    }
                    this.save(xmlDocument, new File(outManifestLocation));
                    this.mLogger.info("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    break;
                }
                case ERROR: {
                    mergingReport.log(this.mLogger);
                    throw new RuntimeException(mergingReport.getReportString());
                }
                default: {
                    throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
                }
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setInjectableValues(ManifestMerger2.Invoker<?> invoker, String packageOverride, int versionCode, String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @Nullable Integer maxSdkVersion) {
        if (!Strings.isNullOrEmpty((String)packageOverride)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.PACKAGE, packageOverride);
        }
        if (versionCode > 0) {
            invoker.setOverride(ManifestMerger2.SystemProperty.VERSION_CODE, String.valueOf(versionCode));
        }
        if (!Strings.isNullOrEmpty((String)versionName)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.VERSION_NAME, versionName);
        }
        if (!Strings.isNullOrEmpty((String)minSdkVersion)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.MIN_SDK_VERSION, minSdkVersion);
        }
        if (!Strings.isNullOrEmpty((String)targetSdkVersion)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestMerger2.SystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
        }
    }

    private void save(XmlDocument xmlDocument, File out) {
        try {
            Files.write((CharSequence)xmlDocument.prettyPrint(), (File)out, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<Pair<String, File>> collectLibraries(List<? extends ManifestDependency> libraries) {
        ImmutableList.Builder manifestFiles = ImmutableList.builder();
        if (libraries != null) {
            AndroidBuilder.collectLibraries(libraries, (ImmutableList.Builder<Pair<String, File>>)manifestFiles);
        }
        return manifestFiles.build();
    }

    private static void collectLibraries(List<? extends ManifestDependency> libraries, ImmutableList.Builder<Pair<String, File>> manifestFiles) {
        for (ManifestDependency manifestDependency : libraries) {
            manifestFiles.add((Object)Pair.of((Object)manifestDependency.getName(), (Object)manifestDependency.getManifest()));
            List<? extends ManifestDependency> manifestDependencies = manifestDependency.getManifestDependencies();
            if (manifestDependencies.isEmpty()) continue;
            AndroidBuilder.collectLibraries(manifestDependencies, manifestFiles);
        }
    }

    public void processManifest(@NonNull File mainManifest, @NonNull List<File> manifestOverlays, @NonNull List<? extends ManifestDependency> libraries, String packageOverride, int versionCode, String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NonNull String outManifestLocation) {
        Preconditions.checkNotNull((Object)mainManifest, (Object)"mainManifest cannot be null.");
        Preconditions.checkNotNull(manifestOverlays, (Object)"manifestOverlays cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifestLocation, (Object)"outManifestLocation cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processManifest() before setTargetInfo() is called.");
        final IAndroidTarget target = this.mTargetInfo.getTarget();
        ICallback callback = new ICallback(){

            public int queryCodenameApiLevel(@NonNull String codename) {
                if (codename.equals(target.getVersion().getCodename())) {
                    return target.getVersion().getApiLevel();
                }
                return 0;
            }
        };
        try {
            Map<String, String> attributeInjection = AndroidBuilder.getAttributeInjectionMap(versionCode, versionName, minSdkVersion, targetSdkVersion);
            if (manifestOverlays.isEmpty() && libraries.isEmpty()) {
                if (attributeInjection.isEmpty() && packageOverride == null) {
                    SdkUtils.copyXmlWithSourceReference((File)mainManifest, (File)new File(outManifestLocation));
                } else {
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), callback);
                    this.doMerge(merger, new File(outManifestLocation), mainManifest, attributeInjection, packageOverride);
                }
            } else {
                File outManifest = new File(outManifestLocation);
                if (!manifestOverlays.isEmpty()) {
                    File mainManifestOut = outManifest;
                    if (!libraries.isEmpty()) {
                        mainManifestOut = File.createTempFile("manifestMerge", ".xml");
                        mainManifestOut.deleteOnExit();
                    }
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), callback);
                    this.doMerge(merger, mainManifestOut, mainManifest, manifestOverlays, attributeInjection, packageOverride);
                    mainManifest = mainManifestOut;
                    attributeInjection = null;
                }
                if (!libraries.isEmpty()) {
                    this.mergeLibraryManifests(mainManifest, libraries, new File(outManifestLocation), attributeInjection, packageOverride, callback);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processTestManifest(@NonNull String testApplicationId, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NonNull String testedApplicationId, @NonNull String instrumentationRunner, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest, @NonNull List<? extends ManifestDependency> libraries, @NonNull File outManifest) {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processTestManifest() before setTargetInfo() is called.");
        final IAndroidTarget target = this.mTargetInfo.getTarget();
        ICallback callback = new ICallback(){

            public int queryCodenameApiLevel(@NonNull String codename) {
                if (codename.equals(target.getVersion().getCodename())) {
                    return target.getVersion().getApiLevel();
                }
                return 0;
            }
        };
        if (!libraries.isEmpty()) {
            try {
                File generatedTestManifest = File.createTempFile("manifestMerge", ".xml");
                AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
                this.mergeLibraryManifests(generatedTestManifest, libraries, outManifest, null, null, callback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, outManifest);
        }
    }

    public void processTestManifest2(@NonNull String testApplicationId, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NonNull String testedApplicationId, @NonNull String instrumentationRunner, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest, @Nullable File testManifestFile, @NonNull List<? extends ManifestDependency> libraries, @NonNull File outManifest, @NonNull File tmpDir) {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        try {
            tmpDir.mkdirs();
            File generatedTestManifest = libraries.isEmpty() && testManifestFile == null ? outManifest : File.createTempFile("manifestMerger", ".xml", tmpDir);
            this.mLogger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
            AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
            if (testManifestFile != null) {
                File mergedTestManifest = File.createTempFile("manifestMerger", ".xml", tmpDir);
                this.mLogger.verbose("Merging user supplied manifest in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
                ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setOverride(ManifestMerger2.SystemProperty.PACKAGE, testApplicationId).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifests(new File[]{generatedTestManifest});
                if (minSdkVersion != null) {
                    invoker.setOverride(ManifestMerger2.SystemProperty.MIN_SDK_VERSION, minSdkVersion);
                }
                if (!targetSdkVersion.equals("-1")) {
                    invoker.setOverride(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                }
                MergingReport mergingReport = invoker.merge();
                if (libraries.isEmpty()) {
                    this.handleMergingResult(mergingReport, outManifest);
                } else {
                    this.handleMergingResult(mergingReport, mergedTestManifest);
                    generatedTestManifest = mergedTestManifest;
                }
            }
            if (!libraries.isEmpty()) {
                MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestMerger2.SystemProperty.PACKAGE, testApplicationId).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).merge();
                this.handleMergingResult(mergingReport, outManifest);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMergingResult(@NonNull MergingReport mergingReport, @NonNull File outFile) {
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(this.mLogger);
            }
            case SUCCESS: {
                XmlDocument xmlDocument = (XmlDocument)mergingReport.getMergedDocument().get();
                try {
                    String annotatedDocument = mergingReport.getActions().blame(xmlDocument);
                    this.mLogger.verbose(annotatedDocument, new Object[0]);
                }
                catch (Exception e) {
                    this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                this.save(xmlDocument, outFile);
                this.mLogger.info("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(this.mLogger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(@NonNull String testApplicationId, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NonNull String testedApplicationId, @NonNull String instrumentationRunner, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest, @NonNull File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private static Map<String, String> getAttributeInjectionMap(int versionCode, @Nullable String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion) {
        HashMap attributeInjection = Maps.newHashMap();
        if (versionCode != -1) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionCode", Integer.toString(versionCode));
        }
        if (versionName != null) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionName", versionName);
        }
        if (minSdkVersion != null) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android minSdkVersion", minSdkVersion);
        }
        if (targetSdkVersion != null) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android targetSdkVersion", targetSdkVersion);
        }
        return attributeInjection;
    }

    private void mergeLibraryManifests(File mainManifest, Iterable<? extends ManifestDependency> directLibraries, File outManifest, Map<String, String> attributeInjection, String packageOverride, @NonNull ICallback callback) throws IOException {
        ArrayList manifests = Lists.newArrayList();
        for (ManifestDependency manifestDependency : directLibraries) {
            List<? extends ManifestDependency> subLibraries = manifestDependency.getManifestDependencies();
            if (subLibraries.isEmpty()) {
                manifests.add(manifestDependency.getManifest());
                continue;
            }
            File mergeLibManifest = File.createTempFile("manifestMerge", ".xml");
            mergeLibManifest.deleteOnExit();
            this.mergeLibraryManifests(manifestDependency.getManifest(), subLibraries, mergeLibManifest, null, null, callback);
            manifests.add(mergeLibManifest);
        }
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), callback);
        this.doMerge(merger, outManifest, mainManifest, manifests, attributeInjection, packageOverride);
    }

    private void doMerge(ManifestMerger merger, File output, File input, Map<String, String> injectionMap, String packageOverride) {
        List<File> list = Collections.emptyList();
        this.doMerge(merger, output, input, list, injectionMap, packageOverride);
    }

    private void doMerge(ManifestMerger merger, File output, File input, List<File> subManifests, Map<String, String> injectionMap, String packageOverride) {
        if (!merger.process(output, input, subManifests.toArray(new File[subManifests.size()]), injectionMap, packageOverride)) {
            throw new RuntimeException("Manifest merging failed. See console for more info.");
        }
    }

    public void processResources(@NonNull File manifestFile, @NonNull File resFolder, @Nullable File assetsDir, @Nullable List<? extends SymbolFileProvider> libraries, @Nullable String packageForR, @Nullable String sourceOutputDir, @Nullable String symbolOutputDir, @Nullable String resPackageOutput, @Nullable String proguardOutput, VariantConfiguration.Type type, boolean debuggable, @NonNull AaptOptions options, @NonNull Collection<String> resourceConfigs, boolean enforceUniquePackageName) throws IOException, InterruptedException, LoggedErrorException {
        String ignoreAssets;
        Preconditions.checkNotNull((Object)manifestFile, (Object)"manifestFile cannot be null.");
        Preconditions.checkNotNull((Object)resFolder, (Object)"resFolder cannot be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options cannot be null.");
        Preconditions.checkArgument((sourceOutputDir != null || resPackageOutput != null ? 1 : 0) != 0, (Object)"No output provided for aapt task");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processResources() before setTargetInfo() is called.");
        if (symbolOutputDir != null || sourceOutputDir != null) {
            Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null if symbolOutputDir or sourceOutputDir is non-null");
        }
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        IAndroidTarget target = this.mTargetInfo.getTarget();
        ArrayList command = Lists.newArrayList();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        command.add(aapt);
        command.add("package");
        if (this.mVerboseExec) {
            command.add("-v");
        }
        command.add("-f");
        command.add("--no-crunch");
        command.add("-I");
        command.add(target.getPath(1));
        command.add("-M");
        command.add(manifestFile.getAbsolutePath());
        if (resFolder.isDirectory()) {
            command.add("-S");
            command.add(resFolder.getAbsolutePath());
        }
        if (assetsDir != null && assetsDir.isDirectory()) {
            command.add("-A");
            command.add(assetsDir.getAbsolutePath());
        }
        if (sourceOutputDir != null) {
            command.add("-m");
            command.add("-J");
            command.add(sourceOutputDir);
        }
        if (resPackageOutput != null) {
            command.add("-F");
            command.add(resPackageOutput);
        }
        if (proguardOutput != null) {
            command.add("-G");
            command.add(proguardOutput);
        }
        if (debuggable) {
            command.add("--debug-mode");
        }
        if (type != VariantConfiguration.Type.TEST && packageForR != null) {
            command.add("--custom-package");
            command.add(packageForR);
            this.mLogger.verbose("Custom package for R class: '%s'", new Object[]{packageForR});
        }
        if (type == VariantConfiguration.Type.LIBRARY) {
            command.add("--non-constant-id");
        }
        if ((ignoreAssets = options.getIgnoreAssets()) != null) {
            command.add("--ignore-assets");
            command.add(ignoreAssets);
        }
        if (options.getFailOnMissingConfigEntry()) {
            if (buildToolInfo.getRevision().getMajor() > 20) {
                command.add("--error-on-missing-config-entry");
            } else {
                throw new IllegalStateException("aaptOptions:failOnMissingConfigEntry cannot be used with SDK Build Tools revision earlier than 21.0.0");
            }
        }
        command.add("-0");
        command.add("apk");
        Collection noCompressList = options.getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                command.add("-0");
                command.add(noCompress);
            }
        }
        if (!resourceConfigs.isEmpty()) {
            command.add("-c");
            Joiner joiner = Joiner.on((char)',');
            command.add(joiner.join(resourceConfigs));
        }
        if (!(symbolOutputDir == null || type != VariantConfiguration.Type.LIBRARY && libraries.isEmpty())) {
            command.add("--output-text-symbols");
            command.add(symbolOutputDir);
        }
        this.mCmdLineRunner.runCmdLine((List)command, null);
        if (sourceOutputDir != null && type != VariantConfiguration.Type.LIBRARY && !libraries.isEmpty()) {
            String msg;
            SymbolLoader fullSymbolValues = null;
            String appPackageName = packageForR;
            if (appPackageName == null) {
                appPackageName = VariantConfiguration.getManifestPackage(manifestFile);
            }
            ArrayListMultimap libMap = ArrayListMultimap.create();
            for (SymbolFileProvider symbolFileProvider : libraries) {
                String packageName = VariantConfiguration.getManifestPackage(symbolFileProvider.getManifest());
                if (appPackageName == null) continue;
                if (appPackageName.equals(packageName)) {
                    if (!enforceUniquePackageName) continue;
                    msg = String.format("Error: A library uses the same package as this project: %s\nYou can temporarily disable this error with android.enforceUniquePackageName=false\nHowever, this is temporary and will be enforced in 1.0", packageName);
                    throw new RuntimeException(msg);
                }
                File rFile = symbolFileProvider.getSymbolFile();
                if (!rFile.isFile()) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(symbolOutputDir, "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put((Object)packageName, (Object)libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get((Object)string);
                if (enforceUniquePackageName && symbols.size() > 1) {
                    msg = String.format("Error: more than one library with package name '%s'\nYou can temporarily disable this error with android.enforceUniquePackageName=false\nHowever, this is temporary and will be enforced in 1.0", string);
                    throw new RuntimeException(msg);
                }
                SymbolWriter writer = new SymbolWriter(sourceOutputDir, string, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void generateApkData(@NonNull File apkFile, @NonNull File outResFolder, @NonNull String mainPkgName, @NonNull String resName) throws InterruptedException, LoggedErrorException, IOException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        ArrayList command = Lists.newArrayList();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        command.add(aapt);
        command.add("dump");
        command.add("badging");
        command.add(apkFile.getPath());
        final ArrayList aaptOutput = Lists.newArrayList();
        this.mCmdLineRunner.runCmdLine((List)command, new CommandLineRunner.CommandLineOutput(){

            public void out(@Nullable String line) {
                if (line != null) {
                    aaptOutput.add(line);
                }
            }

            public void err(@Nullable String line) {
                super.err(line);
            }
        }, null);
        Pattern p = Pattern.compile("^package: name='(.+)' versionCode='([0-9]*)' versionName='(.*)'$");
        String pkgName = null;
        String versionCode = null;
        String versionName = null;
        for (String line : aaptOutput) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            pkgName = m.group(1);
            versionCode = m.group(2);
            versionName = m.group(3);
            break;
        }
        if (pkgName == null) {
            throw new RuntimeException("Failed to find apk information with aapt");
        }
        if (!pkgName.equals(mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <versionCode>%2$s</versionCode>\n    <versionName>%3$s</versionName>\n    <rawPathResId>%4$s</rawPathResId>\n</wearableApp>", pkgName, versionCode, versionName, resName);
        File resXmlFile = new File(outResFolder, "xml");
        resXmlFile.mkdirs();
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public void generateApkDataEntryInManifest(@NonNull File manifestFile) throws InterruptedException, LoggedErrorException, IOException {
        String content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest package=\"\" xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <application>\n        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n                   android:resource=\"@xml/android_wear_micro_apk\" />\n    </application>\n</manifest>\n";
        Files.write((CharSequence)content, (File)manifestFile, (Charset)Charsets.UTF_8);
    }

    public void compileAllAidlFiles(@NonNull List<File> sourceFolders, @NonNull File sourceOutputDir, @Nullable File parcelableOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllAidlFiles() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), fullImportList, sourceOutputDir, parcelableOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(@NonNull File sourceFolder, @NonNull File aidlFile, @NonNull File sourceOutputDir, @Nullable File parcelableOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)aidlFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAidlFile() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), importFolders, sourceOutputDir, parcelableOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        processor.processFile(sourceFolder, aidlFile);
    }

    public void compileAllRenderscriptFiles(@NonNull List<File> sourceFolders, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull File resOutputDir, @NonNull File objOutputDir, @NonNull File libOutputDir, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, @Nullable Set<String> abiFilters) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllRenderscriptFiles() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String renderscript = buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(sourceFolders, importFolders, sourceOutputDir, resOutputDir, objOutputDir, libOutputDir, buildToolInfo, targetApi, debugBuild, optimLevel, ndkMode, supportMode, abiFilters);
        processor.build(this.mCmdLineRunner);
    }

    @NonNull
    public List<File> getLeafFolders(@NonNull String extension, List<File> ... importFolders) {
        ArrayList results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                }
                catch (LoggedErrorException e) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public void convertByteCode(@NonNull Iterable<File> inputs, @NonNull Iterable<File> preDexedLibraries, @NonNull File outDexFolder, @NonNull DexOptions dexOptions, @Nullable List<String> additionalParameters, boolean incremental) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(inputs, (Object)"inputs cannot be null.");
        Preconditions.checkNotNull(preDexedLibraries, (Object)"preDexedLibraries cannot be null.");
        Preconditions.checkNotNull((Object)outDexFolder, (Object)"outDexFolder cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        Preconditions.checkArgument((boolean)outDexFolder.isDirectory(), (Object)"outDexFolder must be a folder");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call convertByteCode() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        ArrayList command = Lists.newArrayList();
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-JXmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("--dex");
        if (this.mVerboseExec) {
            command.add("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            command.add("--force-jumbo");
        }
        if (incremental) {
            command.add("--incremental");
            command.add("--no-strict");
        }
        if (additionalParameters != null) {
            for (String arg : additionalParameters) {
                command.add(arg);
            }
        }
        command.add("--output");
        command.add(outDexFolder.getAbsolutePath());
        ArrayList inputList = Lists.newArrayList();
        for (File f : inputs) {
            if (f == null || !f.exists()) continue;
            inputList.add(f.getAbsolutePath());
        }
        if (!inputList.isEmpty()) {
            this.mLogger.verbose("Dex inputs: " + inputList, new Object[0]);
            command.addAll(inputList);
        }
        ArrayList libraryList = Lists.newArrayList();
        for (File f : preDexedLibraries) {
            if (f == null || !f.exists()) continue;
            libraryList.add(f.getAbsolutePath());
        }
        if (!libraryList.isEmpty()) {
            this.mLogger.verbose("Dex pre-dexed inputs: " + libraryList, new Object[0]);
            command.addAll(libraryList);
        }
        this.mCmdLineRunner.runCmdLine((List)command, null);
    }

    public void preDexLibrary(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call preDexLibrary() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        PreDexCache.getCache().preDexLibrary(inputFile, outFile, dexOptions, buildToolInfo, this.mVerboseExec, this.mCmdLineRunner);
    }

    public static void preDexLibrary(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions, @NonNull BuildToolInfo buildToolInfo, boolean verbose, @NonNull CommandLineRunner commandLineRunner) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        ArrayList command = Lists.newArrayList();
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-JXmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("--dex");
        if (verbose) {
            command.add("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            command.add("--force-jumbo");
        }
        command.add("--output");
        command.add(outFile.getAbsolutePath());
        command.add(inputFile.getAbsolutePath());
        commandLineRunner.runCmdLine((List)command, null);
    }

    public void packageApk(@NonNull String androidResPkgLocation, @NonNull File dexFolder, @NonNull Collection<File> packagedJars, @Nullable String javaResourcesLocation, @Nullable Collection<File> jniLibsFolders, @Nullable Set<String> abiFilters, boolean jniDebugBuild, @Nullable SigningConfig signingConfig, @Nullable PackagingOptions packagingOptions, @NonNull String outApkLocation) throws DuplicateFileException, FileNotFoundException, KeytoolException, PackagerException, SigningException {
        Preconditions.checkNotNull((Object)androidResPkgLocation, (Object)"androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull((Object)dexFolder, (Object)"dexFolder cannot be null.");
        Preconditions.checkArgument((boolean)dexFolder.isDirectory(), (Object)"dexFolder is not a directory");
        Preconditions.checkNotNull((Object)outApkLocation, (Object)"outApkLocation cannot be null.");
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady() && (certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias())) == null) {
            throw new SigningException("Failed to read key from keystore", new Object[0]);
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, dexFolder, certificateInfo, this.mCreatedBy, packagingOptions, this.mLogger);
            packager.setJniDebugMode(jniDebugBuild);
            JavaResourceProcessor resProcessor = new JavaResourceProcessor(packager);
            if (javaResourcesLocation != null) {
                resProcessor.addSourceFolder(javaResourcesLocation);
            }
            HashSet hashs = Sets.newHashSet();
            for (File jar : packagedJars) {
                String hash = AndroidBuilder.getFileHash(jar);
                if (hash == null) {
                    throw new PackagerException("Unable to compute hash of " + jar.getAbsolutePath(), new Object[0]);
                }
                if (hashs.contains(hash)) continue;
                hashs.add(hash);
                packager.addResourcesFromJar(jar);
            }
            if (jniLibsFolders != null) {
                for (File jniFolder : jniLibsFolders) {
                    if (!jniFolder.isDirectory()) continue;
                    packager.addNativeLibraries(jniFolder, abiFilters);
                }
            }
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static String getFileHash(@NonNull File file) {
        try {
            HashCode hashCode = Files.hash((File)file, (HashFunction)Hashing.sha1());
            return hashCode.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

