/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.List;
import net.spy.memcached.ClientMode;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KetamaConnectionFactory
extends DefaultConnectionFactory {
    public KetamaConnectionFactory(ClientMode clientMode, int qLen, int bufSize, long opQueueMaxBlockTime) {
        super(clientMode, qLen, bufSize, DefaultHashAlgorithm.KETAMA_HASH);
    }

    public KetamaConnectionFactory() {
        this(DEFAULT_CLIENT_MODE, 16384, 16384, DEFAULT_OP_QUEUE_MAX_BLOCK_TIME);
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new KetamaNodeLocator(nodes, this.getHashAlg());
    }
}

