/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ObjectRestoreResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMetadata
implements ServerSideEncryptionResult,
ObjectExpirationResult,
ObjectRestoreResult,
Cloneable {
    private Map<String, String> userMetadata;
    private Map<String, Object> metadata;
    public static final String AES_256_SERVER_SIDE_ENCRYPTION = "AES256";
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.metadata));
    }

    public Object getRawMetadataValue(String key) {
        return this.metadata.get(key);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", md5Base64);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-amz-version-id");
    }

    @Override
    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Override
    public void setServerSideEncryption(String serverSideEncryption) {
        this.metadata.put("x-amz-server-side-encryption", serverSideEncryption);
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    @Override
    public void setExpirationTimeRuleId(String expirationTimeRuleId) {
        this.expirationTimeRuleId = expirationTimeRuleId;
    }

    @Override
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    @Override
    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    @Override
    public void setOngoingRestore(boolean ongoingRestore) {
        this.ongoingRestore = ongoingRestore;
    }

    @Override
    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    public String getUserMetaDataOf(String key) {
        return this.userMetadata == null ? null : this.userMetadata.get(key);
    }

    public ObjectMetadata() {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
    }

    private ObjectMetadata(ObjectMetadata from) {
        this.userMetadata = from.userMetadata == null ? null : new HashMap<String, String>(from.userMetadata);
        this.metadata = from.metadata == null ? null : new HashMap<String, Object>(from.metadata);
        this.expirationTime = from.expirationTime;
        this.expirationTimeRuleId = from.expirationTimeRuleId;
        this.httpExpiresDate = from.httpExpiresDate;
        this.ongoingRestore = from.ongoingRestore;
        this.restoreExpirationTime = from.restoreExpirationTime;
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }
}

