/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteVaultRequestMarshaller
implements Marshaller<Request<DeleteVaultRequest>, DeleteVaultRequest> {
    @Override
    public Request<DeleteVaultRequest> marshall(DeleteVaultRequest deleteVaultRequest) {
        if (deleteVaultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteVaultRequest> request = new DefaultRequest<DeleteVaultRequest>(deleteVaultRequest, "AmazonGlacier");
        String target = "Glacier.DeleteVault";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}";
        uriResourcePath = uriResourcePath.replace("{accountId}", deleteVaultRequest.getAccountId() == null ? "" : StringUtils.fromString(deleteVaultRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", deleteVaultRequest.getVaultName() == null ? "" : StringUtils.fromString(deleteVaultRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

