/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.internal.config.SignerConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SignerFactory {
    private static final String QUERY_STRING_SIGNER = "QueryStringSignerType";
    private static final String VERSION_THREE_SIGNER = "AWS3SignerType";
    private static final String VERSION_FOUR_SIGNER = "AWS4SignerType";
    private static final Map<String, Class<? extends Signer>> SIGNERS = new ConcurrentHashMap<String, Class<? extends Signer>>();

    private SignerFactory() {
    }

    public static void registerSigner(String signerType, Class<? extends Signer> signerClass) {
        if (signerType == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (signerClass == null) {
            throw new IllegalArgumentException("signerClass cannot be null");
        }
        SIGNERS.put(signerType, signerClass);
    }

    public static Signer getSigner(String serviceName, String regionName) {
        Signer signer;
        InternalConfig config = InternalConfig.Factory.getInternalConfig();
        SignerConfig signerConfig = config.getSignerConfig(serviceName, regionName);
        String signerType = signerConfig.getSignerType();
        Class<? extends Signer> signerClass = SIGNERS.get(signerType);
        if (signerClass == null) {
            throw new IllegalStateException("No signer implementation registered for signer type " + signerType + ".");
        }
        try {
            signer = signerClass.newInstance();
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName() + " for signer type " + signerType + ".", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName() + " for signer type " + signerType + ".", exception);
        }
        if (signer instanceof ServiceAwareSigner) {
            ((ServiceAwareSigner)signer).setServiceName(serviceName);
        }
        if (signer instanceof RegionAwareSigner) {
            ((RegionAwareSigner)signer).setRegionName(regionName);
        }
        return signer;
    }

    public static Signer getSigner(String serviceName) {
        return SignerFactory.getSigner(serviceName, null);
    }

    static {
        SIGNERS.put(QUERY_STRING_SIGNER, QueryStringSigner.class);
        SIGNERS.put(VERSION_THREE_SIGNER, AWS3Signer.class);
        SIGNERS.put(VERSION_FOUR_SIGNER, AWS4Signer.class);
    }
}

