/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLoadBalancerRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private List<Listener> listeners;
    private List<String> availabilityZones;
    private List<String> subnets;
    private List<String> securityGroups;
    private String scheme;

    public CreateLoadBalancerRequest() {
    }

    public CreateLoadBalancerRequest(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerRequest(String loadBalancerName, List<Listener> listeners, List<String> availabilityZones) {
        this.loadBalancerName = loadBalancerName;
        this.listeners = listeners;
        this.availabilityZones = availabilityZones;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
            return;
        }
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>(listeners.size());
        listenersCopy.addAll(listeners);
        this.listeners = listenersCopy;
    }

    public CreateLoadBalancerRequest withListeners(Listener ... listeners) {
        if (this.getListeners() == null) {
            this.setListeners(new ArrayList<Listener>(listeners.length));
        }
        for (Listener value : listeners) {
            this.getListeners().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
        } else {
            ArrayList<Listener> listenersCopy = new ArrayList<Listener>(listeners.size());
            listenersCopy.addAll(listeners);
            this.listeners = listenersCopy;
        }
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public List<String> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ArrayList<String> subnetsCopy = new ArrayList<String>(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public CreateLoadBalancerRequest withSubnets(String ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ArrayList<String> subnetsCopy = new ArrayList<String>(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public CreateLoadBalancerRequest withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public CreateLoadBalancerRequest withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getListeners() != null) {
            sb.append("Listeners: " + this.getListeners() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones() + ",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups() + ",");
        }
        if (this.getScheme() != null) {
            sb.append("Scheme: " + this.getScheme());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getListeners() == null ? 0 : ((Object)this.getListeners()).hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : ((Object)this.getAvailabilityZones()).hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : ((Object)this.getSubnets()).hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : ((Object)this.getSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getScheme() == null ? 0 : this.getScheme().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getListeners() == null ^ this.getListeners() == null) {
            return false;
        }
        if (other.getListeners() != null && !((Object)other.getListeners()).equals(this.getListeners())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !((Object)other.getAvailabilityZones()).equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !((Object)other.getSubnets()).equals(this.getSubnets())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !((Object)other.getSecurityGroups()).equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getScheme() == null ^ this.getScheme() == null) {
            return false;
        }
        return other.getScheme() == null || other.getScheme().equals(this.getScheme());
    }
}

