/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;

public class SendMessageRequest
extends AmazonWebServiceRequest {
    private String queueUrl;
    private String messageBody;
    private Integer delaySeconds;

    public SendMessageRequest() {
    }

    public SendMessageRequest(String queueUrl, String messageBody) {
        this.queueUrl = queueUrl;
        this.messageBody = messageBody;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public SendMessageRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    public SendMessageRequest withMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Integer getDelaySeconds() {
        return this.delaySeconds;
    }

    public void setDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public SendMessageRequest withDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ", ");
        }
        if (this.getMessageBody() != null) {
            sb.append("MessageBody: " + this.getMessageBody() + ", ");
        }
        if (this.getDelaySeconds() != null) {
            sb.append("DelaySeconds: " + this.getDelaySeconds() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getMessageBody() == null ? 0 : this.getMessageBody().hashCode());
        hashCode = 31 * hashCode + (this.getDelaySeconds() == null ? 0 : this.getDelaySeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getMessageBody() == null ^ this.getMessageBody() == null) {
            return false;
        }
        if (other.getMessageBody() != null && !other.getMessageBody().equals(this.getMessageBody())) {
            return false;
        }
        if (other.getDelaySeconds() == null ^ this.getDelaySeconds() == null) {
            return false;
        }
        return other.getDelaySeconds() == null || other.getDelaySeconds().equals(this.getDelaySeconds());
    }
}

