/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A notification summary return object.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/NotificationSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class NotificationSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The type of notification.
     * </p>
     */
    private String type;
    /**
     * <p>
     * Summary of lens upgrade.
     * </p>
     */
    private LensUpgradeSummary lensUpgradeSummary;

    /**
     * <p>
     * The type of notification.
     * </p>
     * 
     * @param type
     *        The type of notification.
     * @see NotificationType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * 
     * @return The type of notification.
     * @see NotificationType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * 
     * @param type
     *        The type of notification.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NotificationType
     */

    public NotificationSummary withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * 
     * @param type
     *        The type of notification.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NotificationType
     */

    public NotificationSummary withType(NotificationType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * Summary of lens upgrade.
     * </p>
     * 
     * @param lensUpgradeSummary
     *        Summary of lens upgrade.
     */

    public void setLensUpgradeSummary(LensUpgradeSummary lensUpgradeSummary) {
        this.lensUpgradeSummary = lensUpgradeSummary;
    }

    /**
     * <p>
     * Summary of lens upgrade.
     * </p>
     * 
     * @return Summary of lens upgrade.
     */

    public LensUpgradeSummary getLensUpgradeSummary() {
        return this.lensUpgradeSummary;
    }

    /**
     * <p>
     * Summary of lens upgrade.
     * </p>
     * 
     * @param lensUpgradeSummary
     *        Summary of lens upgrade.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public NotificationSummary withLensUpgradeSummary(LensUpgradeSummary lensUpgradeSummary) {
        setLensUpgradeSummary(lensUpgradeSummary);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getLensUpgradeSummary() != null)
            sb.append("LensUpgradeSummary: ").append(getLensUpgradeSummary());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof NotificationSummary == false)
            return false;
        NotificationSummary other = (NotificationSummary) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getLensUpgradeSummary() == null ^ this.getLensUpgradeSummary() == null)
            return false;
        if (other.getLensUpgradeSummary() != null && other.getLensUpgradeSummary().equals(this.getLensUpgradeSummary()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getLensUpgradeSummary() == null) ? 0 : getLensUpgradeSummary().hashCode());
        return hashCode;
    }

    @Override
    public NotificationSummary clone() {
        try {
            return (NotificationSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.wellarchitected.model.transform.NotificationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
