/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.PageClassification;
import java.util.List;

@SdkInternalApi
public class PageClassificationMarshaller {
    private static final MarshallingInfo<List> PAGETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageType").build();
    private static final MarshallingInfo<List> PAGENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageNumber").build();
    private static final PageClassificationMarshaller instance = new PageClassificationMarshaller();

    public static PageClassificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(PageClassification pageClassification, ProtocolMarshaller protocolMarshaller) {
        if (pageClassification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pageClassification.getPageType(), PAGETYPE_BINDING);
            protocolMarshaller.marshall(pageClassification.getPageNumber(), PAGENUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

