/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.OperatingSystem;
import com.amazonaws.services.simplesystemsmanagement.model.PatchComplianceLevel;
import com.amazonaws.services.simplesystemsmanagement.model.PatchFilterGroup;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetPatchBaselineResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String baselineId;
    private String name;
    private String operatingSystem;
    private PatchFilterGroup globalFilters;
    private PatchRuleGroup approvalRules;
    private SdkInternalList<String> approvedPatches;
    private String approvedPatchesComplianceLevel;
    private SdkInternalList<String> rejectedPatches;
    private SdkInternalList<String> patchGroups;
    private Date createdDate;
    private Date modifiedDate;
    private String description;

    public void setBaselineId(String baselineId) {
        this.baselineId = baselineId;
    }

    public String getBaselineId() {
        return this.baselineId;
    }

    public GetPatchBaselineResult withBaselineId(String baselineId) {
        this.setBaselineId(baselineId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GetPatchBaselineResult withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public GetPatchBaselineResult withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem.toString();
    }

    public GetPatchBaselineResult withOperatingSystem(OperatingSystem operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public void setGlobalFilters(PatchFilterGroup globalFilters) {
        this.globalFilters = globalFilters;
    }

    public PatchFilterGroup getGlobalFilters() {
        return this.globalFilters;
    }

    public GetPatchBaselineResult withGlobalFilters(PatchFilterGroup globalFilters) {
        this.setGlobalFilters(globalFilters);
        return this;
    }

    public void setApprovalRules(PatchRuleGroup approvalRules) {
        this.approvalRules = approvalRules;
    }

    public PatchRuleGroup getApprovalRules() {
        return this.approvalRules;
    }

    public GetPatchBaselineResult withApprovalRules(PatchRuleGroup approvalRules) {
        this.setApprovalRules(approvalRules);
        return this;
    }

    public List<String> getApprovedPatches() {
        if (this.approvedPatches == null) {
            this.approvedPatches = new SdkInternalList();
        }
        return this.approvedPatches;
    }

    public void setApprovedPatches(Collection<String> approvedPatches) {
        if (approvedPatches == null) {
            this.approvedPatches = null;
            return;
        }
        this.approvedPatches = new SdkInternalList(approvedPatches);
    }

    public GetPatchBaselineResult withApprovedPatches(String ... approvedPatches) {
        if (this.approvedPatches == null) {
            this.setApprovedPatches((Collection<String>)new SdkInternalList(approvedPatches.length));
        }
        for (String ele : approvedPatches) {
            this.approvedPatches.add((Object)ele);
        }
        return this;
    }

    public GetPatchBaselineResult withApprovedPatches(Collection<String> approvedPatches) {
        this.setApprovedPatches(approvedPatches);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
    }

    public String getApprovedPatchesComplianceLevel() {
        return this.approvedPatchesComplianceLevel;
    }

    public GetPatchBaselineResult withApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
        this.setApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
        return this;
    }

    public void setApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel.toString();
    }

    public GetPatchBaselineResult withApprovedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
        this.setApprovedPatchesComplianceLevel(approvedPatchesComplianceLevel);
        return this;
    }

    public List<String> getRejectedPatches() {
        if (this.rejectedPatches == null) {
            this.rejectedPatches = new SdkInternalList();
        }
        return this.rejectedPatches;
    }

    public void setRejectedPatches(Collection<String> rejectedPatches) {
        if (rejectedPatches == null) {
            this.rejectedPatches = null;
            return;
        }
        this.rejectedPatches = new SdkInternalList(rejectedPatches);
    }

    public GetPatchBaselineResult withRejectedPatches(String ... rejectedPatches) {
        if (this.rejectedPatches == null) {
            this.setRejectedPatches((Collection<String>)new SdkInternalList(rejectedPatches.length));
        }
        for (String ele : rejectedPatches) {
            this.rejectedPatches.add((Object)ele);
        }
        return this;
    }

    public GetPatchBaselineResult withRejectedPatches(Collection<String> rejectedPatches) {
        this.setRejectedPatches(rejectedPatches);
        return this;
    }

    public List<String> getPatchGroups() {
        if (this.patchGroups == null) {
            this.patchGroups = new SdkInternalList();
        }
        return this.patchGroups;
    }

    public void setPatchGroups(Collection<String> patchGroups) {
        if (patchGroups == null) {
            this.patchGroups = null;
            return;
        }
        this.patchGroups = new SdkInternalList(patchGroups);
    }

    public GetPatchBaselineResult withPatchGroups(String ... patchGroups) {
        if (this.patchGroups == null) {
            this.setPatchGroups((Collection<String>)new SdkInternalList(patchGroups.length));
        }
        for (String ele : patchGroups) {
            this.patchGroups.add((Object)ele);
        }
        return this;
    }

    public GetPatchBaselineResult withPatchGroups(Collection<String> patchGroups) {
        this.setPatchGroups(patchGroups);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public GetPatchBaselineResult withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public GetPatchBaselineResult withModifiedDate(Date modifiedDate) {
        this.setModifiedDate(modifiedDate);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public GetPatchBaselineResult withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaselineId() != null) {
            sb.append("BaselineId: ").append(this.getBaselineId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getGlobalFilters() != null) {
            sb.append("GlobalFilters: ").append(this.getGlobalFilters()).append(",");
        }
        if (this.getApprovalRules() != null) {
            sb.append("ApprovalRules: ").append(this.getApprovalRules()).append(",");
        }
        if (this.getApprovedPatches() != null) {
            sb.append("ApprovedPatches: ").append(this.getApprovedPatches()).append(",");
        }
        if (this.getApprovedPatchesComplianceLevel() != null) {
            sb.append("ApprovedPatchesComplianceLevel: ").append(this.getApprovedPatchesComplianceLevel()).append(",");
        }
        if (this.getRejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(this.getRejectedPatches()).append(",");
        }
        if (this.getPatchGroups() != null) {
            sb.append("PatchGroups: ").append(this.getPatchGroups()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getModifiedDate() != null) {
            sb.append("ModifiedDate: ").append(this.getModifiedDate()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineResult)) {
            return false;
        }
        GetPatchBaselineResult other = (GetPatchBaselineResult)obj;
        if (other.getBaselineId() == null ^ this.getBaselineId() == null) {
            return false;
        }
        if (other.getBaselineId() != null && !other.getBaselineId().equals(this.getBaselineId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getGlobalFilters() == null ^ this.getGlobalFilters() == null) {
            return false;
        }
        if (other.getGlobalFilters() != null && !other.getGlobalFilters().equals(this.getGlobalFilters())) {
            return false;
        }
        if (other.getApprovalRules() == null ^ this.getApprovalRules() == null) {
            return false;
        }
        if (other.getApprovalRules() != null && !other.getApprovalRules().equals(this.getApprovalRules())) {
            return false;
        }
        if (other.getApprovedPatches() == null ^ this.getApprovedPatches() == null) {
            return false;
        }
        if (other.getApprovedPatches() != null && !other.getApprovedPatches().equals(this.getApprovedPatches())) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() == null ^ this.getApprovedPatchesComplianceLevel() == null) {
            return false;
        }
        if (other.getApprovedPatchesComplianceLevel() != null && !other.getApprovedPatchesComplianceLevel().equals(this.getApprovedPatchesComplianceLevel())) {
            return false;
        }
        if (other.getRejectedPatches() == null ^ this.getRejectedPatches() == null) {
            return false;
        }
        if (other.getRejectedPatches() != null && !other.getRejectedPatches().equals(this.getRejectedPatches())) {
            return false;
        }
        if (other.getPatchGroups() == null ^ this.getPatchGroups() == null) {
            return false;
        }
        if (other.getPatchGroups() != null && !other.getPatchGroups().equals(this.getPatchGroups())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getModifiedDate() == null ^ this.getModifiedDate() == null) {
            return false;
        }
        if (other.getModifiedDate() != null && !other.getModifiedDate().equals(this.getModifiedDate())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaselineId() == null ? 0 : this.getBaselineId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalFilters() == null ? 0 : this.getGlobalFilters().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalRules() == null ? 0 : this.getApprovalRules().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatches() == null ? 0 : this.getApprovedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getApprovedPatchesComplianceLevel() == null ? 0 : this.getApprovedPatchesComplianceLevel().hashCode());
        hashCode = 31 * hashCode + (this.getRejectedPatches() == null ? 0 : this.getRejectedPatches().hashCode());
        hashCode = 31 * hashCode + (this.getPatchGroups() == null ? 0 : this.getPatchGroups().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedDate() == null ? 0 : this.getModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public GetPatchBaselineResult clone() {
        try {
            return (GetPatchBaselineResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

