/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        SdkInternalList replyToAddressesList;
        Message message;
        Destination destination;
        if (sendEmailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendEmailRequest.getSource()));
        }
        if ((destination = sendEmailRequest.getDestination()) != null) {
            SdkInternalList bccAddressesList;
            SdkInternalList ccAddressesList;
            SdkInternalList toAddressesList = (SdkInternalList)destination.getToAddresses();
            if (!toAddressesList.isEmpty() || !toAddressesList.isAutoConstruct()) {
                int toAddressesListIndex = 1;
                for (Object toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (!(ccAddressesList = (SdkInternalList)destination.getCcAddresses()).isEmpty() || !ccAddressesList.isAutoConstruct()) {
                int ccAddressesListIndex = 1;
                for (Object ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString((String)ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (!(bccAddressesList = (SdkInternalList)destination.getBccAddresses()).isEmpty() || !bccAddressesList.isAutoConstruct()) {
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString((String)bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if ((message = sendEmailRequest.getMessage()) != null) {
            Body body;
            Content subject = message.getSubject();
            if (subject != null) {
                if (subject.getData() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString((String)subject.getData()));
                }
                if (subject.getCharset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString((String)subject.getCharset()));
                }
            }
            if ((body = message.getBody()) != null) {
                Content html;
                Content text = body.getText();
                if (text != null) {
                    if (text.getData() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString((String)text.getData()));
                    }
                    if (text.getCharset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString((String)text.getCharset()));
                    }
                }
                if ((html = body.getHtml()) != null) {
                    if (html.getData() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString((String)html.getData()));
                    }
                    if (html.getCharset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString((String)html.getCharset()));
                    }
                }
            }
        }
        if (!(replyToAddressesList = (SdkInternalList)sendEmailRequest.getReplyToAddresses()).isEmpty() || !replyToAddressesList.isAutoConstruct()) {
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString((String)sendEmailRequest.getReturnPath()));
        }
        if (sendEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendEmailRequest.getSourceArn()));
        }
        if (sendEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendEmailRequest.getReturnPathArn()));
        }
        return request;
    }
}

