/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.route53.AmazonRoute53Async;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneResult;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ChangeTagsForResourceRequest;
import com.amazonaws.services.route53.model.ChangeTagsForResourceResult;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.CreateReusableDelegationSetResult;
import com.amazonaws.services.route53.model.DeleteHealthCheckRequest;
import com.amazonaws.services.route53.model.DeleteHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.DeleteReusableDelegationSetResult;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetCheckerIpRangesRequest;
import com.amazonaws.services.route53.model.GetCheckerIpRangesResult;
import com.amazonaws.services.route53.model.GetGeoLocationRequest;
import com.amazonaws.services.route53.model.GetGeoLocationResult;
import com.amazonaws.services.route53.model.GetHealthCheckCountRequest;
import com.amazonaws.services.route53.model.GetHealthCheckCountResult;
import com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonResult;
import com.amazonaws.services.route53.model.GetHealthCheckRequest;
import com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.amazonaws.services.route53.model.GetHealthCheckStatusRequest;
import com.amazonaws.services.route53.model.GetHealthCheckStatusResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.GetReusableDelegationSetRequest;
import com.amazonaws.services.route53.model.GetReusableDelegationSetResult;
import com.amazonaws.services.route53.model.ListGeoLocationsRequest;
import com.amazonaws.services.route53.model.ListGeoLocationsResult;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest;
import com.amazonaws.services.route53.model.ListReusableDelegationSetsResult;
import com.amazonaws.services.route53.model.ListTagsForResourceRequest;
import com.amazonaws.services.route53.model.ListTagsForResourceResult;
import com.amazonaws.services.route53.model.ListTagsForResourcesRequest;
import com.amazonaws.services.route53.model.ListTagsForResourcesResult;
import com.amazonaws.services.route53.model.UpdateHealthCheckRequest;
import com.amazonaws.services.route53.model.UpdateHealthCheckResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonRoute53AsyncClient
extends AmazonRoute53Client
implements AmazonRoute53Async {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonRoute53AsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRoute53AsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonRoute53AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest getHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHostedZone(getHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<GetHostedZoneResult> getHostedZoneAsync(final GetHostedZoneRequest getHostedZoneRequest, final AsyncHandler<GetHostedZoneRequest, GetHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHostedZoneResult>(){

            @Override
            public GetHostedZoneResult call() throws Exception {
                GetHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHostedZone(getHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getHostedZoneRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest getChangeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getChange(getChangeRequest);
            }
        });
    }

    @Override
    public Future<GetChangeResult> getChangeAsync(final GetChangeRequest getChangeRequest, final AsyncHandler<GetChangeRequest, GetChangeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetChangeResult>(){

            @Override
            public GetChangeResult call() throws Exception {
                GetChangeResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getChange(getChangeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getChangeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(final GetGeoLocationRequest getGeoLocationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetGeoLocationResult>(){

            @Override
            public GetGeoLocationResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getGeoLocation(getGeoLocationRequest);
            }
        });
    }

    @Override
    public Future<GetGeoLocationResult> getGeoLocationAsync(final GetGeoLocationRequest getGeoLocationRequest, final AsyncHandler<GetGeoLocationRequest, GetGeoLocationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetGeoLocationResult>(){

            @Override
            public GetGeoLocationResult call() throws Exception {
                GetGeoLocationResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getGeoLocation(getGeoLocationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getGeoLocationRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourcesResult> listTagsForResourcesAsync(final ListTagsForResourcesRequest listTagsForResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourcesResult>(){

            @Override
            public ListTagsForResourcesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTagsForResources(listTagsForResourcesRequest);
            }
        });
    }

    @Override
    public Future<ListTagsForResourcesResult> listTagsForResourcesAsync(final ListTagsForResourcesRequest listTagsForResourcesRequest, final AsyncHandler<ListTagsForResourcesRequest, ListTagsForResourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourcesResult>(){

            @Override
            public ListTagsForResourcesResult call() throws Exception {
                ListTagsForResourcesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTagsForResources(listTagsForResourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTagsForResourcesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHealthCheckResult> deleteHealthCheckAsync(final DeleteHealthCheckRequest deleteHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHealthCheckResult>(){

            @Override
            public DeleteHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteHealthCheck(deleteHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<DeleteHealthCheckResult> deleteHealthCheckAsync(final DeleteHealthCheckRequest deleteHealthCheckRequest, final AsyncHandler<DeleteHealthCheckRequest, DeleteHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHealthCheckResult>(){

            @Override
            public DeleteHealthCheckResult call() throws Exception {
                DeleteHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHealthCheck(deleteHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteHealthCheckRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest listResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listResourceRecordSets(listResourceRecordSetsRequest);
            }
        });
    }

    @Override
    public Future<ListResourceRecordSetsResult> listResourceRecordSetsAsync(final ListResourceRecordSetsRequest listResourceRecordSetsRequest, final AsyncHandler<ListResourceRecordSetsRequest, ListResourceRecordSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListResourceRecordSetsResult>(){

            @Override
            public ListResourceRecordSetsResult call() throws Exception {
                ListResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listResourceRecordSets(listResourceRecordSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listResourceRecordSetsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReusableDelegationSetResult> deleteReusableDelegationSetAsync(final DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteReusableDelegationSetResult>(){

            @Override
            public DeleteReusableDelegationSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteReusableDelegationSet(deleteReusableDelegationSetRequest);
            }
        });
    }

    @Override
    public Future<DeleteReusableDelegationSetResult> deleteReusableDelegationSetAsync(final DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest, final AsyncHandler<DeleteReusableDelegationSetRequest, DeleteReusableDelegationSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteReusableDelegationSetResult>(){

            @Override
            public DeleteReusableDelegationSetResult call() throws Exception {
                DeleteReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteReusableDelegationSet(deleteReusableDelegationSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteReusableDelegationSetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckResult> getHealthCheckAsync(final GetHealthCheckRequest getHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckResult>(){

            @Override
            public GetHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheck(getHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckResult> getHealthCheckAsync(final GetHealthCheckRequest getHealthCheckRequest, final AsyncHandler<GetHealthCheckRequest, GetHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckResult>(){

            @Override
            public GetHealthCheckResult call() throws Exception {
                GetHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheck(getHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getHealthCheckRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateReusableDelegationSetResult> createReusableDelegationSetAsync(final CreateReusableDelegationSetRequest createReusableDelegationSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReusableDelegationSetResult>(){

            @Override
            public CreateReusableDelegationSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createReusableDelegationSet(createReusableDelegationSetRequest);
            }
        });
    }

    @Override
    public Future<CreateReusableDelegationSetResult> createReusableDelegationSetAsync(final CreateReusableDelegationSetRequest createReusableDelegationSetRequest, final AsyncHandler<CreateReusableDelegationSetRequest, CreateReusableDelegationSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReusableDelegationSetResult>(){

            @Override
            public CreateReusableDelegationSetResult call() throws Exception {
                CreateReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createReusableDelegationSet(createReusableDelegationSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createReusableDelegationSetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(final GetCheckerIpRangesRequest getCheckerIpRangesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCheckerIpRangesResult>(){

            @Override
            public GetCheckerIpRangesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getCheckerIpRanges(getCheckerIpRangesRequest);
            }
        });
    }

    @Override
    public Future<GetCheckerIpRangesResult> getCheckerIpRangesAsync(final GetCheckerIpRangesRequest getCheckerIpRangesRequest, final AsyncHandler<GetCheckerIpRangesRequest, GetCheckerIpRangesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetCheckerIpRangesResult>(){

            @Override
            public GetCheckerIpRangesResult call() throws Exception {
                GetCheckerIpRangesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getCheckerIpRanges(getCheckerIpRangesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getCheckerIpRangesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateVPCFromHostedZoneResult> disassociateVPCFromHostedZoneAsync(final DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisassociateVPCFromHostedZoneResult>(){

            @Override
            public DisassociateVPCFromHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.disassociateVPCFromHostedZone(disassociateVPCFromHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<DisassociateVPCFromHostedZoneResult> disassociateVPCFromHostedZoneAsync(final DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest, final AsyncHandler<DisassociateVPCFromHostedZoneRequest, DisassociateVPCFromHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisassociateVPCFromHostedZoneResult>(){

            @Override
            public DisassociateVPCFromHostedZoneResult call() throws Exception {
                DisassociateVPCFromHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.disassociateVPCFromHostedZone(disassociateVPCFromHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)disassociateVPCFromHostedZoneRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckLastFailureReasonResult> getHealthCheckLastFailureReasonAsync(final GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckLastFailureReasonResult>(){

            @Override
            public GetHealthCheckLastFailureReasonResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheckLastFailureReason(getHealthCheckLastFailureReasonRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckLastFailureReasonResult> getHealthCheckLastFailureReasonAsync(final GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest, final AsyncHandler<GetHealthCheckLastFailureReasonRequest, GetHealthCheckLastFailureReasonResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckLastFailureReasonResult>(){

            @Override
            public GetHealthCheckLastFailureReasonResult call() throws Exception {
                GetHealthCheckLastFailureReasonResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckLastFailureReason(getHealthCheckLastFailureReasonRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getHealthCheckLastFailureReasonRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateHealthCheckResult> createHealthCheckAsync(final CreateHealthCheckRequest createHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHealthCheckResult>(){

            @Override
            public CreateHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createHealthCheck(createHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<CreateHealthCheckResult> createHealthCheckAsync(final CreateHealthCheckRequest createHealthCheckRequest, final AsyncHandler<CreateHealthCheckRequest, CreateHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHealthCheckResult>(){

            @Override
            public CreateHealthCheckResult call() throws Exception {
                CreateHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHealthCheck(createHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createHealthCheckRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(final ListHealthChecksRequest listHealthChecksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHealthChecksResult>(){

            @Override
            public ListHealthChecksResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listHealthChecks(listHealthChecksRequest);
            }
        });
    }

    @Override
    public Future<ListHealthChecksResult> listHealthChecksAsync(final ListHealthChecksRequest listHealthChecksRequest, final AsyncHandler<ListHealthChecksRequest, ListHealthChecksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHealthChecksResult>(){

            @Override
            public ListHealthChecksResult call() throws Exception {
                ListHealthChecksResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHealthChecks(listHealthChecksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listHealthChecksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(final ListGeoLocationsRequest listGeoLocationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGeoLocationsResult>(){

            @Override
            public ListGeoLocationsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listGeoLocations(listGeoLocationsRequest);
            }
        });
    }

    @Override
    public Future<ListGeoLocationsResult> listGeoLocationsAsync(final ListGeoLocationsRequest listGeoLocationsRequest, final AsyncHandler<ListGeoLocationsRequest, ListGeoLocationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListGeoLocationsResult>(){

            @Override
            public ListGeoLocationsResult call() throws Exception {
                ListGeoLocationsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listGeoLocations(listGeoLocationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listGeoLocationsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(final GetHealthCheckCountRequest getHealthCheckCountRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckCountResult>(){

            @Override
            public GetHealthCheckCountResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheckCount(getHealthCheckCountRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckCountResult> getHealthCheckCountAsync(final GetHealthCheckCountRequest getHealthCheckCountRequest, final AsyncHandler<GetHealthCheckCountRequest, GetHealthCheckCountResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckCountResult>(){

            @Override
            public GetHealthCheckCountResult call() throws Exception {
                GetHealthCheckCountResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckCount(getHealthCheckCountRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getHealthCheckCountRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ChangeTagsForResourceResult> changeTagsForResourceAsync(final ChangeTagsForResourceRequest changeTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeTagsForResourceResult>(){

            @Override
            public ChangeTagsForResourceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.changeTagsForResource(changeTagsForResourceRequest);
            }
        });
    }

    @Override
    public Future<ChangeTagsForResourceResult> changeTagsForResourceAsync(final ChangeTagsForResourceRequest changeTagsForResourceRequest, final AsyncHandler<ChangeTagsForResourceRequest, ChangeTagsForResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeTagsForResourceResult>(){

            @Override
            public ChangeTagsForResourceResult call() throws Exception {
                ChangeTagsForResourceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeTagsForResource(changeTagsForResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)changeTagsForResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthCheckStatusResult> getHealthCheckStatusAsync(final GetHealthCheckStatusRequest getHealthCheckStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckStatusResult>(){

            @Override
            public GetHealthCheckStatusResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getHealthCheckStatus(getHealthCheckStatusRequest);
            }
        });
    }

    @Override
    public Future<GetHealthCheckStatusResult> getHealthCheckStatusAsync(final GetHealthCheckStatusRequest getHealthCheckStatusRequest, final AsyncHandler<GetHealthCheckStatusRequest, GetHealthCheckStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetHealthCheckStatusResult>(){

            @Override
            public GetHealthCheckStatusResult call() throws Exception {
                GetHealthCheckStatusResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getHealthCheckStatus(getHealthCheckStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getHealthCheckStatusRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest listHostedZonesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listHostedZones(listHostedZonesRequest);
            }
        });
    }

    @Override
    public Future<ListHostedZonesResult> listHostedZonesAsync(final ListHostedZonesRequest listHostedZonesRequest, final AsyncHandler<ListHostedZonesRequest, ListHostedZonesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListHostedZonesResult>(){

            @Override
            public ListHostedZonesResult call() throws Exception {
                ListHostedZonesResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listHostedZones(listHostedZonesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listHostedZonesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetReusableDelegationSetResult> getReusableDelegationSetAsync(final GetReusableDelegationSetRequest getReusableDelegationSetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetReusableDelegationSetResult>(){

            @Override
            public GetReusableDelegationSetResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.getReusableDelegationSet(getReusableDelegationSetRequest);
            }
        });
    }

    @Override
    public Future<GetReusableDelegationSetResult> getReusableDelegationSetAsync(final GetReusableDelegationSetRequest getReusableDelegationSetRequest, final AsyncHandler<GetReusableDelegationSetRequest, GetReusableDelegationSetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetReusableDelegationSetResult>(){

            @Override
            public GetReusableDelegationSetResult call() throws Exception {
                GetReusableDelegationSetResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.getReusableDelegationSet(getReusableDelegationSetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getReusableDelegationSetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHealthCheckResult> updateHealthCheckAsync(final UpdateHealthCheckRequest updateHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateHealthCheckResult>(){

            @Override
            public UpdateHealthCheckResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.updateHealthCheck(updateHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<UpdateHealthCheckResult> updateHealthCheckAsync(final UpdateHealthCheckRequest updateHealthCheckRequest, final AsyncHandler<UpdateHealthCheckRequest, UpdateHealthCheckResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateHealthCheckResult>(){

            @Override
            public UpdateHealthCheckResult call() throws Exception {
                UpdateHealthCheckResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.updateHealthCheck(updateHealthCheckRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateHealthCheckRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest deleteHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.deleteHostedZone(deleteHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<DeleteHostedZoneResult> deleteHostedZoneAsync(final DeleteHostedZoneRequest deleteHostedZoneRequest, final AsyncHandler<DeleteHostedZoneRequest, DeleteHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteHostedZoneResult>(){

            @Override
            public DeleteHostedZoneResult call() throws Exception {
                DeleteHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.deleteHostedZone(deleteHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteHostedZoneRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<AssociateVPCWithHostedZoneResult> associateVPCWithHostedZoneAsync(final AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateVPCWithHostedZoneResult>(){

            @Override
            public AssociateVPCWithHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.associateVPCWithHostedZone(associateVPCWithHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<AssociateVPCWithHostedZoneResult> associateVPCWithHostedZoneAsync(final AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest, final AsyncHandler<AssociateVPCWithHostedZoneRequest, AssociateVPCWithHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateVPCWithHostedZoneResult>(){

            @Override
            public AssociateVPCWithHostedZoneResult call() throws Exception {
                AssociateVPCWithHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.associateVPCWithHostedZone(associateVPCWithHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)associateVPCWithHostedZoneRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest createHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.createHostedZone(createHostedZoneRequest);
            }
        });
    }

    @Override
    public Future<CreateHostedZoneResult> createHostedZoneAsync(final CreateHostedZoneRequest createHostedZoneRequest, final AsyncHandler<CreateHostedZoneRequest, CreateHostedZoneResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateHostedZoneResult>(){

            @Override
            public CreateHostedZoneResult call() throws Exception {
                CreateHostedZoneResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.createHostedZone(createHostedZoneRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createHostedZoneRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(final ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListReusableDelegationSetsResult>(){

            @Override
            public ListReusableDelegationSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listReusableDelegationSets(listReusableDelegationSetsRequest);
            }
        });
    }

    @Override
    public Future<ListReusableDelegationSetsResult> listReusableDelegationSetsAsync(final ListReusableDelegationSetsRequest listReusableDelegationSetsRequest, final AsyncHandler<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListReusableDelegationSetsResult>(){

            @Override
            public ListReusableDelegationSetsResult call() throws Exception {
                ListReusableDelegationSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listReusableDelegationSets(listReusableDelegationSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listReusableDelegationSetsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.listTagsForResource(listTagsForResourceRequest);
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest listTagsForResourceRequest, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.listTagsForResource(listTagsForResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTagsForResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                return AmazonRoute53AsyncClient.this.changeResourceRecordSets(changeResourceRecordSetsRequest);
            }
        });
    }

    @Override
    public Future<ChangeResourceRecordSetsResult> changeResourceRecordSetsAsync(final ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest, final AsyncHandler<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeResourceRecordSetsResult>(){

            @Override
            public ChangeResourceRecordSetsResult call() throws Exception {
                ChangeResourceRecordSetsResult result;
                try {
                    result = AmazonRoute53AsyncClient.this.changeResourceRecordSets(changeResourceRecordSetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)changeResourceRecordSetsRequest, (Object)result);
                return result;
            }
        });
    }
}

